"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.STEP = exports.NO_INDEX_PATTERNS = exports.MIN_ALERTS = exports.MAX_ALERTS = exports.AlertSelectionQuery = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _fp = require("lodash/fp");
var _react2 = _interopRequireWildcard(require("react"));
var _use_experimental_features = require("../../../../../common/hooks/use_experimental_features");
var _kibana = require("../../../../../common/lib/kibana");
var _get_common_time_ranges = require("../helpers/get_common_time_ranges");
var _containers = require("../../../../../sourcerer/containers");
var _model = require("../../../../../sourcerer/store/model");
var _use_create_data_view = require("../../../../../common/hooks/use_create_data_view");
var _use_data_view = require("../../../../../data_view_manager/hooks/use_data_view");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/attack_discovery/pages/settings_flyout/alert_selection/alert_selection_query/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MAX_ALERTS = exports.MAX_ALERTS = 500;
const MIN_ALERTS = exports.MIN_ALERTS = 50;
const STEP = exports.STEP = 50;
const NO_INDEX_PATTERNS = exports.NO_INDEX_PATTERNS = [];
const updateButtonProps = {
  fill: false
};
const AlertSelectionQueryComponent = ({
  filterManager,
  onSettingsChanged,
  settings
}) => {
  const {
    unifiedSearch: {
      ui: {
        SearchBar
      }
    }
  } = (0, _kibana.useKibana)().services;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    dataView: experimentalDataView,
    status
  } = (0, _use_data_view.useDataView)(_model.SourcererScopeName.detections);

  // get the sourcerer `DataViewSpec` for alerts:
  const {
    sourcererDataView: oldSourcererDataViewSpec,
    loading: oldIsLoadingIndexPattern
  } = (0, _containers.useSourcererDataView)(_model.SourcererScopeName.detections);

  // create a `DataView` from the `DataViewSpec`:
  const {
    dataView: oldDataView,
    loading: oldIsLoadingDataView
  } = (0, _use_create_data_view.useCreateDataView)({
    dataViewSpec: oldSourcererDataViewSpec,
    loading: oldIsLoadingIndexPattern,
    skip: newDataViewPickerEnabled // skip data view creation if the new data view picker is enabled
  });
  const alertsDataView = newDataViewPickerEnabled ? experimentalDataView : oldDataView;
  const isLoadingIndexPattern = newDataViewPickerEnabled ? status !== 'ready' : oldIsLoadingDataView;

  // create a container for the alerts `DataView`, as required by the search bar:
  const indexPatterns = (0, _react2.useMemo)(() => alertsDataView ? [alertsDataView] : NO_INDEX_PATTERNS, [alertsDataView]);

  // Users accumulate an "unsubmitted" query as they type in the search bar,
  // but have not pressed the 'Enter' key to submit the query, (which would
  // call `onQuerySubmit`).
  //
  // This unsubmitted query is stored in `unSubmittedQuery`.
  //
  // To match the behavior of Discover, `setQuery` must be called with the
  // `unSubmittedQuery` query when:
  //
  // 1) The user selects a new time range
  // 2) The user clicks the refresh button
  //
  // Also to match the behavior of Discover, we must NOT call `setQuery` with
  // the `unSubmittedQuery` query when the user clicks the `Save` button.
  const [unSubmittedQuery, setUnSubmittedQuery] = _react2.default.useState(undefined);

  /**
   * `debouncedOnQueryChange` is called by the `SearchBar` as the user types in the input
   */
  const debouncedOnQueryChange = (0, _react2.useCallback)(inputQuery => {
    const debouncedFunction = (0, _fp.debounce)(100, debouncedQuery => {
      setUnSubmittedQuery(debouncedQuery);
    });
    return debouncedFunction(inputQuery);
  }, []);

  // get the common time ranges for the date picker:
  const commonlyUsedRanges = (0, _react2.useMemo)(() => (0, _get_common_time_ranges.getCommonTimeRanges)(), []);

  /**
   * `onTimeChange` is called by the `EuiSuperDatePicker` when the user:
   * 1) selects a new time range
   * 2) clicks the refresh button
   */
  const onTimeChange = (0, _react2.useCallback)(({
    start: startDate,
    end: endDate
  }) => {
    const query = unSubmittedQuery != null ? {
      query: unSubmittedQuery,
      // <-- set the query to the unsubmitted query
      language: 'kuery'
    } : settings.query;
    const updatedSettings = {
      ...settings,
      end: endDate,
      start: startDate,
      query
    };
    onSettingsChanged === null || onSettingsChanged === void 0 ? void 0 : onSettingsChanged(updatedSettings);
  }, [onSettingsChanged, settings, unSubmittedQuery]);

  /**
   * `onFiltersUpdated` is called by the `SearchBar` when the filters, (which
   * appear below the `SearchBar` input), are updated.
   */
  const onFiltersUpdated = (0, _react2.useCallback)(newFilters => {
    filterManager.setFilters(newFilters);
  }, [filterManager]);

  /**
   * `onQuerySubmit` is called by the `SearchBar` when the user presses `Enter`
   */
  const onQuerySubmit = (0, _react2.useCallback)(({
    query: newQuery
  }) => {
    if (newQuery != null) {
      onSettingsChanged === null || onSettingsChanged === void 0 ? void 0 : onSettingsChanged({
        ...settings,
        query: newQuery
      });
    }
  }, [onSettingsChanged, settings]);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react.css)`
        gap: ${euiTheme.size.s};
      `,
    "data-test-subj": "alertSelectionQuery",
    gutterSize: "none",
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react.css)`
          .uniSearchBar {
            padding: 0;
          }
        `,
    grow: 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(SearchBar, {
    appName: "siem",
    "data-test-subj": "alertSelectionSearchBar",
    indexPatterns: indexPatterns,
    filters: settings.filters,
    showDatePicker: false,
    showFilterBar: true,
    showQueryInput: true,
    showSavedQueryControls: false,
    showSubmitButton: false,
    isLoading: isLoadingIndexPattern,
    onFiltersUpdated: onFiltersUpdated,
    onQueryChange: ({
      query: debouncedQuery
    }) => {
      debouncedOnQueryChange(debouncedQuery === null || debouncedQuery === void 0 ? void 0 : debouncedQuery.query);
    },
    onQuerySubmit: onQuerySubmit,
    query: settings.query,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react.css)`
          min-width: 308px;
        `,
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSuperDatePicker, {
    commonlyUsedRanges: commonlyUsedRanges,
    compressed: true,
    "data-test-subj": "alertSelectionDatePicker",
    end: settings.end,
    isDisabled: false,
    onTimeChange: onTimeChange,
    showUpdateButton: "iconOnly",
    start: settings.start,
    updateButtonProps: updateButtonProps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 9
    }
  })));
};
AlertSelectionQueryComponent.displayName = 'AlertSelectionQuery';
const AlertSelectionQuery = exports.AlertSelectionQuery = /*#__PURE__*/_react2.default.memo(AlertSelectionQueryComponent);