"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TakeAction = void 0;
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _use_assistant_availability = require("../../../../assistant/use_assistant_availability");
var _use_add_to_case = require("./use_add_to_case");
var _use_add_to_existing_case = require("./use_add_to_existing_case");
var _use_view_in_ai_assistant = require("../attack_discovery_panel/view_in_ai_assistant/use_view_in_ai_assistant");
var _common = require("../../../../../common");
var _kibana = require("../../../../common/lib/kibana");
var i18n = _interopRequireWildcard(require("./translations"));
var _update_alerts_modal = require("./update_alerts_modal");
var _use_attack_discovery_bulk = require("../../use_attack_discovery_bulk");
var _use_update_alerts_status = require("./use_update_alerts_status");
var _is_attack_discovery_alert = require("../../utils/is_attack_discovery_alert");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/attack_discovery/pages/results/take_action/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TakeActionComponent = ({
  attackDiscoveries,
  buttonSize = 's',
  buttonText,
  refetchFindAttackDiscoveries,
  replacements,
  setSelectedAttackDiscoveries
}) => {
  const [pendingAction, setPendingAction] = (0, _react.useState)(null);
  const {
    services: {
      cases
    }
  } = (0, _kibana.useKibana)();
  const {
    hasSearchAILakeConfigurations
  } = (0, _use_assistant_availability.useAssistantAvailability)();
  const userCasesPermissions = cases.helpers.canUseCases([_common.APP_ID]);
  const canUserCreateAndReadCases = (0, _react.useCallback)(() => userCasesPermissions.createComment && userCasesPermissions.read, [userCasesPermissions.createComment, userCasesPermissions.read]);
  const {
    disabled: addToCaseDisabled,
    onAddToNewCase
  } = (0, _use_add_to_case.useAddToNewCase)({
    canUserCreateAndReadCases,
    title: attackDiscoveries.map(discovery => discovery.title).join(', ')
  });
  const {
    onAddToExistingCase
  } = (0, _use_add_to_existing_case.useAddToExistingCase)({
    canUserCreateAndReadCases
  });

  // boilerplate for the take action popover:
  const takeActionContextMenuPopoverId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'takeActionContextMenuPopover'
  });
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const onButtonClick = (0, _react.useCallback)(() => setPopover(!isPopoverOpen), [isPopoverOpen]);
  const closePopover = (0, _react.useCallback)(() => setPopover(false), []);

  // markdown for the attack discovery, which will be exported to the case, or to the assistant:
  const markdown = (0, _react.useMemo)(() => attackDiscoveries.map(attackDiscovery => (0, _elasticAssistantCommon.getAttackDiscoveryMarkdown)({
    attackDiscovery,
    replacements
  })).join('\n\n'), [attackDiscoveries, replacements]);
  const alertIds = (0, _react.useMemo)(() => [...new Set(attackDiscoveries.flatMap(attackDiscovery => attackDiscovery.alertIds))], [attackDiscoveries]);
  const attackDiscoveryIds = (0, _react.useMemo)(() => attackDiscoveries.flatMap(attackDiscovery => attackDiscovery.id != null ? [attackDiscovery.id] : []), [attackDiscoveries]);
  const {
    mutateAsync: attackDiscoveryBulk
  } = (0, _use_attack_discovery_bulk.useAttackDiscoveryBulk)();
  const {
    mutateAsync: updateAlertStatus
  } = (0, _use_update_alerts_status.useUpdateAlertsStatus)();

  /**
   * Called by the modal when the user confirms the action,
   * or directly when the user selects an action in AI for SOC.
   */
  const onConfirm = (0, _react.useCallback)(async ({
    updateAlerts,
    workflowStatus
  }) => {
    setPendingAction(null);
    await attackDiscoveryBulk({
      ids: attackDiscoveryIds,
      kibanaAlertWorkflowStatus: workflowStatus
    });
    if (updateAlerts && alertIds.length > 0) {
      const originalAlertIds = (0, _elasticAssistantCommon.getOriginalAlertIds)({
        alertIds,
        replacements
      });
      await updateAlertStatus({
        ids: originalAlertIds,
        kibanaAlertWorkflowStatus: workflowStatus
      });
    }
    setSelectedAttackDiscoveries({});
    refetchFindAttackDiscoveries === null || refetchFindAttackDiscoveries === void 0 ? void 0 : refetchFindAttackDiscoveries();
  }, [alertIds, attackDiscoveryBulk, attackDiscoveryIds, refetchFindAttackDiscoveries, replacements, setSelectedAttackDiscoveries, updateAlertStatus]);
  const onUpdateWorkflowStatus = (0, _react.useCallback)(async workflowStatus => {
    closePopover();
    setPendingAction(workflowStatus);
    if (hasSearchAILakeConfigurations) {
      // there's no modal for AI for SOC, so we call onConfirm directly
      onConfirm({
        updateAlerts: false,
        workflowStatus
      });
    }
  }, [closePopover, hasSearchAILakeConfigurations, onConfirm]);
  const onClickAddToNewCase = (0, _react.useCallback)(async () => {
    closePopover();
    onAddToNewCase({
      alertIds,
      markdownComments: [markdown],
      replacements
    });
    await (refetchFindAttackDiscoveries === null || refetchFindAttackDiscoveries === void 0 ? void 0 : refetchFindAttackDiscoveries());
  }, [closePopover, onAddToNewCase, alertIds, markdown, replacements, refetchFindAttackDiscoveries]);
  const onClickAddToExistingCase = (0, _react.useCallback)(() => {
    closePopover();
    onAddToExistingCase({
      alertIds,
      markdownComments: [markdown],
      replacements
    });
  }, [closePopover, onAddToExistingCase, alertIds, markdown, replacements]);
  const {
    showAssistantOverlay,
    disabled: viewInAiAssistantDisabled
  } = (0, _use_view_in_ai_assistant.useViewInAiAssistant)({
    attackDiscovery: attackDiscoveries[0],
    replacements
  });
  const onViewInAiAssistant = (0, _react.useCallback)(() => {
    closePopover();
    showAssistantOverlay === null || showAssistantOverlay === void 0 ? void 0 : showAssistantOverlay();
  }, [closePopover, showAssistantOverlay]);

  // button for the popover:
  const button = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "takeActionPopoverButton",
    iconSide: "right",
    iconType: "arrowDown",
    onClick: onButtonClick,
    size: buttonSize,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 7
    }
  }, buttonText !== null && buttonText !== void 0 ? buttonText : i18n.TAKE_ACTION), [buttonSize, buttonText, onButtonClick]);

  // items for the popover:
  const items = (0, _react.useMemo)(() => [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": "addToCase",
    disabled: addToCaseDisabled,
    key: "addToCase",
    onClick: onClickAddToNewCase,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 9
    }
  }, i18n.ADD_TO_NEW_CASE), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": "addToExistingCase",
    disabled: addToCaseDisabled,
    key: "addToExistingCase",
    onClick: onClickAddToExistingCase,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 9
    }
  }, i18n.ADD_TO_EXISTING_CASE), attackDiscoveries.length === 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": "viewInAiAssistant",
    disabled: viewInAiAssistantDisabled,
    key: "viewInAiAssistant",
    onClick: onViewInAiAssistant,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 11
    }
  }, i18n.VIEW_IN_AI_ASSISTANT) : []].flat(), [addToCaseDisabled, attackDiscoveries.length, onClickAddToExistingCase, onClickAddToNewCase, onViewInAiAssistant, viewInAiAssistantDisabled]);
  const allItems = (0, _react.useMemo)(() => {
    const isSingleAttackDiscovery = attackDiscoveries.length === 1;
    const firstAttackDiscovery = isSingleAttackDiscovery ? attackDiscoveries[0] : null;
    const isAlert = firstAttackDiscovery && (0, _is_attack_discovery_alert.isAttackDiscoveryAlert)(firstAttackDiscovery);
    const isOpen = isAlert && firstAttackDiscovery.alertWorkflowStatus === 'open';
    const isAcknowledged = isAlert && firstAttackDiscovery.alertWorkflowStatus === 'acknowledged';
    const isClosed = isAlert && firstAttackDiscovery.alertWorkflowStatus === 'closed';
    const markAsOpenItem = !isOpen ? [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      "data-test-subj": "markAsOpen",
      key: "markAsOpen",
      onClick: () => onUpdateWorkflowStatus('open'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 280,
        columnNumber: 11
      }
    }, i18n.MARK_AS_OPEN)] : [];
    const markAsAcknowledgedItem = !isAcknowledged ? [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      "data-test-subj": "markAsAcknowledged",
      key: "markAsAcknowledged",
      onClick: () => onUpdateWorkflowStatus('acknowledged'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 292,
        columnNumber: 11
      }
    }, i18n.MARK_AS_ACKNOWLEDGED)] : [];
    const markAsClosedItem = !isClosed ? [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      "data-test-subj": "markAsClosed",
      key: "markAsClosed",
      onClick: () => onUpdateWorkflowStatus('closed'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 304,
        columnNumber: 11
      }
    }, i18n.MARK_AS_CLOSED)] : [];
    return [...markAsOpenItem, ...markAsAcknowledgedItem, ...markAsClosedItem, ...items].flat();
  }, [attackDiscoveries, items, onUpdateWorkflowStatus]);
  const onCloseOrCancel = (0, _react.useCallback)(() => {
    setPendingAction(null);
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "downCenter",
    button: button,
    closePopover: closePopover,
    "data-test-subj": "takeAction",
    id: takeActionContextMenuPopoverId,
    isOpen: isPopoverOpen,
    panelPaddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 323,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: allItems,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 332,
      columnNumber: 9
    }
  })), pendingAction != null && !hasSearchAILakeConfigurations && /*#__PURE__*/_react.default.createElement(_update_alerts_modal.UpdateAlertsModal, {
    alertsCount: alertIds.length,
    attackDiscoveriesCount: attackDiscoveryIds.length,
    onCancel: onCloseOrCancel,
    onClose: onCloseOrCancel,
    onConfirm: onConfirm,
    workflowStatus: pendingAction,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 336,
      columnNumber: 9
    }
  }));
};
TakeActionComponent.displayName = 'TakeAction';
const TakeAction = exports.TakeAction = /*#__PURE__*/_react.default.memo(TakeActionComponent);