"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Title = void 0;
var _eui = require("@elastic/eui");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _accordion_button = require("../accordion_button");
var _badges = require("../badges");
var _details_flyout = require("../../../../../settings_flyout/schedule/details_flyout");
var i18n = _interopRequireWildcard(require("./translations"));
var _is_attack_discovery_alert = require("../../../../../utils/is_attack_discovery_alert");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/attack_discovery/pages/results/attack_discovery_panel/panel_header/primary_interactions/title/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TitleComponent = ({
  attackDiscovery,
  isOpen,
  isSelected,
  onToggle,
  replacements,
  setIsOpen,
  setIsSelected,
  showAnonymized = false
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const htmlId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'attackDiscoveryAccordion'
  });
  const checkboxId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'attackDiscoveryCheckbox'
  });
  const [scheduleDetailsId, setScheduleDetailsId] = (0, _react2.useState)(undefined);
  const onCheckboxChange = (0, _react2.useCallback)(() => {
    if (attackDiscovery.id != null) {
      setIsSelected === null || setIsSelected === void 0 ? void 0 : setIsSelected({
        id: attackDiscovery.id,
        selected: !isSelected
      });
    }
  }, [attackDiscovery.id, isSelected, setIsSelected]);
  const updateIsOpen = (0, _react2.useCallback)(() => {
    const newState = isOpen === 'open' ? 'closed' : 'open';
    setIsOpen(newState);
    onToggle === null || onToggle === void 0 ? void 0 : onToggle(newState);
  }, [isOpen, onToggle, setIsOpen]);
  const alertRuleUuid = (0, _react2.useMemo)(() => (0, _is_attack_discovery_alert.isAttackDiscoveryAlert)(attackDiscovery) ? attackDiscovery.alertRuleUuid : undefined, [attackDiscovery]);
  const isScheduled = (0, _react2.useMemo)(() => alertRuleUuid != null && alertRuleUuid !== _elasticAssistantCommon.ATTACK_DISCOVERY_AD_HOC_RULE_ID, [alertRuleUuid]);
  const openScheduleDetails = (0, _react2.useCallback)(() => {
    setScheduleDetailsId(alertRuleUuid);
  }, [alertRuleUuid]);
  const onClose = (0, _react2.useCallback)(() => setScheduleDetailsId(undefined), []);
  const accordionButton = (0, _react2.useMemo)(() => {
    (0, _is_attack_discovery_alert.isAttackDiscoveryAlert)(attackDiscovery);
    return /*#__PURE__*/_react2.default.createElement(_accordion_button.AccordionButton, {
      connectorName: (0, _is_attack_discovery_alert.isAttackDiscoveryAlert)(attackDiscovery) ? attackDiscovery.connectorName : undefined,
      isLoading: false,
      replacements: replacements,
      showAnonymized: showAnonymized,
      title: attackDiscovery.title,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 7
      }
    });
  }, [attackDiscovery, replacements, showAnonymized]);
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    css: (0, _react.css)`
          gap: ${euiTheme.size.xs};
        `,
    "data-test-subj": "title",
    gutterSize: "none",
    responsive: false,
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiCheckbox, {
    checked: isSelected,
    css: (0, _react.css)`
              display: inline;
            `,
    "data-test-subj": "attackDiscoveryCheckbox",
    id: checkboxId,
    onChange: onCheckboxChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiAccordion, {
    buttonContent: accordionButton,
    "data-test-subj": "attackDiscoveryAccordion",
    forceState: isOpen,
    id: htmlId,
    onToggle: updateIsOpen,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement("span", {
    "data-test-subj": "emptyAccordionContent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 13
    }
  }))), isScheduled && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
    content: i18n.SCHEDULED_ATTACK_DISCOVERY,
    "data-test-subj": "scheduledTooltip",
    position: "top",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": i18n.OPEN_SCHEDULE_DETAILS,
    "data-test-subj": "scheduleButton",
    iconType: "calendar",
    onClick: openScheduleDetails,
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_badges.Badges, {
    attackDiscovery: attackDiscovery,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 11
    }
  }))), scheduleDetailsId && /*#__PURE__*/_react2.default.createElement(_details_flyout.DetailsFlyout, {
    scheduleId: scheduleDetailsId,
    onClose: onClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 29
    }
  }));
};
const Title = exports.Title = /*#__PURE__*/_react2.default.memo(TitleComponent);