"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SkippedAlertsIndexMigration = exports.CreateAlertsMigrationResponse = exports.CreateAlertsMigrationRequestBody = exports.AlertsReindexOptions = exports.AlertsIndexMigrationSuccess = exports.AlertsIndexMigrationError = void 0;
var _zod = require("@kbn/zod");
var _zodHelpers = require("@kbn/zod-helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Initiates alerts migration API endpoint
 *   version: 2023-10-31
 */

const AlertsReindexOptions = exports.AlertsReindexOptions = _zod.z.object({
  /**
   * The throttle for the migration task in sub-requests per second. Corresponds to requests_per_second on the Reindex API.
   */
  requests_per_second: _zod.z.number().int().min(1).optional(),
  /**
   * Number of alerts to migrate per batch. Corresponds to the source.size option on the Reindex API.
   */
  size: _zod.z.number().int().min(1).optional(),
  /**
   * The number of subtasks for the migration task. Corresponds to slices on the Reindex API.
   */
  slices: _zod.z.number().int().min(1).optional()
});
const AlertsIndexMigrationSuccess = exports.AlertsIndexMigrationSuccess = _zod.z.object({
  index: _zod.z.string(),
  migration_id: _zod.z.string(),
  migration_index: _zod.z.string()
});
const AlertsIndexMigrationError = exports.AlertsIndexMigrationError = _zod.z.object({
  index: _zod.z.string(),
  error: _zod.z.object({
    message: _zod.z.string(),
    status_code: _zod.z.string()
  })
});
const SkippedAlertsIndexMigration = exports.SkippedAlertsIndexMigration = _zod.z.object({
  index: _zod.z.string()
});
const CreateAlertsMigrationRequestBody = exports.CreateAlertsMigrationRequestBody = _zod.z.object({
  /**
   * Array of index names to migrate.
   */
  index: _zod.z.array(_zod.z.string().min(1).superRefine(_zodHelpers.isNonEmptyString)).min(1)
}).merge(AlertsReindexOptions);
const CreateAlertsMigrationResponse = exports.CreateAlertsMigrationResponse = _zod.z.object({
  indices: _zod.z.array(_zod.z.union([AlertsIndexMigrationSuccess, AlertsIndexMigrationError, SkippedAlertsIndexMigration]))
});