"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withLink = exports.useGetLinkUrl = exports.useGetLinkProps = exports.securityLink = exports.isModifiedEvent = exports.formatPath = exports.LinkButton = exports.LinkAnchor = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _navigation = require("./navigation");
var _constants = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/packages/navigation/src/links.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * It returns the `url` to use in link `href`.
 */
const useGetLinkUrl = () => {
  const {
    getAppUrl
  } = (0, _navigation.useGetAppUrl)();
  const getLinkUrl = (0, _react.useCallback)(({
    app,
    id,
    path = '',
    absolute = false,
    urlState
  }) => {
    const formattedPath = urlState ? formatPath(path, urlState) : path;
    return getAppUrl({
      appId: app,
      deepLinkId: id,
      path: formattedPath,
      absolute
    });
  }, [getAppUrl]);
  return getLinkUrl;
};

/**
 * It returns the `onClick` and `href` props to use in link components based on the` deepLinkId` and `path` parameters.
 */
exports.useGetLinkUrl = useGetLinkUrl;
const useGetLinkProps = () => {
  const getLinkUrl = useGetLinkUrl();
  const {
    navigateTo
  } = (0, _navigation.useNavigateTo)();
  const getLinkProps = (0, _react.useCallback)(({
    app,
    id,
    path,
    urlState,
    onClick: onClickProps,
    skipKibanaNavigation = false
  }) => {
    const url = getLinkUrl({
      app,
      id,
      path,
      urlState
    });
    return {
      href: url,
      onClick: ev => {
        if (isModifiedEvent(ev)) {
          return;
        }
        if (onClickProps) {
          onClickProps(ev);
        }
        if (!skipKibanaNavigation) {
          ev.preventDefault();
          navigateTo({
            url
          });
        }
      }
    };
  }, [getLinkUrl, navigateTo]);
  return getLinkProps;
};

/**
 * HOC that wraps any Link component and makes it a navigation Link.
 */
exports.useGetLinkProps = useGetLinkProps;
const withLink = Component => /*#__PURE__*/_react.default.memo(function WithLink({
  app,
  id,
  path,
  urlState,
  onClick: _onClick,
  ...rest
}) {
  const getLink = useGetLinkProps();
  const getLinkPropsParams = {
    app,
    id,
    path,
    urlState,
    onClick: _onClick
  };
  const {
    onClick,
    href
  } = getLink({
    ...getLinkPropsParams,
    ...(rest.target === '_blank' && {
      skipKibanaNavigation: true
    })
  });
  return /*#__PURE__*/_react.default.createElement(Component, (0, _extends2.default)({
    onClick: onClick,
    href: href
  }, rest, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 12
    }
  }));
});

/**
 * Security Solutions internal link button.
 *
 * `<LinkButton deepLinkId={SecurityPageName.hosts} />;`
 */
exports.withLink = withLink;
const LinkButton = exports.LinkButton = withLink(_eui.EuiButton);

/**
 * Security Solutions internal link anchor.
 *
 * `<LinkAnchor deepLinkId={SecurityPageName.hosts} />;`
 */
const LinkAnchor = exports.LinkAnchor = withLink(_eui.EuiLink);

// Utils

const formatPath = (path, urlState) => {
  const urlStateClean = urlState.replace('?', '');
  const [urlPath, parameterPath] = path.split('?');
  let queryParams = '';
  if (urlStateClean && parameterPath) {
    queryParams = `?${parameterPath}&${urlStateClean}`;
  } else if (parameterPath) {
    queryParams = `?${parameterPath}`;
  } else if (urlStateClean) {
    queryParams = `?${urlStateClean}`;
  }
  return `${urlPath}${queryParams}`;
};
exports.formatPath = formatPath;
const isModifiedEvent = event => event.metaKey || event.altKey || event.ctrlKey || event.shiftKey;
exports.isModifiedEvent = isModifiedEvent;
const securityLink = pageName => {
  return `${_constants.SECURITY_UI_APP_ID}:${pageName}`;
};
exports.securityLink = securityLink;