"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InnerBreadcrumb = exports.BreadcrumbsProvider = exports.Breadcrumb = void 0;
exports.createBreadcrumbsChangeHandler = createBreadcrumbsChangeHandler;
exports.getDocTitle = getDocTitle;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/components/breadcrumb.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const BreadcrumbsContext = /*#__PURE__*/(0, _react.createContext)(undefined);
/**
 * Component that automatically sets breadcrumbs and document title based on the render tree.
 *
 * @example
 * // Breadcrumbs will be set to: "Users > Create"
 * // Document title will be set to: "Create - Users"
 *
 * ```typescript
 * <Breadcrumb text="Users">
 *   <Table />
 *   {showForm && (
 *     <Breadcrumb text="Create">
 *       <Form />
 *     </Breadcrumb>
 *   )}
 * </Breadcrumb>
 * ```
 */
const Breadcrumb = ({
  children,
  ...breadcrumb
}) => {
  const context = (0, _react.useContext)(BreadcrumbsContext);
  const component = /*#__PURE__*/_react.default.createElement(InnerBreadcrumb, {
    breadcrumb: breadcrumb,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 21
    }
  }, children);
  if (context) {
    return component;
  }
  return /*#__PURE__*/_react.default.createElement(BreadcrumbsProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 10
    }
  }, component);
};
exports.Breadcrumb = Breadcrumb;
/**
 * Component that can be used to define any side effects that should occur when breadcrumbs change.
 *
 * By default the breadcrumbs in application chrome are set and the document title is updated.
 *
 * @example
 * ```typescript
 * <Breadcrumbs onChange={(breadcrumbs) => setBreadcrumbs(breadcrumbs)}>
 *   <Breadcrumb text="Users" />
 * </Breadcrumbs>
 * ```
 */
const BreadcrumbsProvider = ({
  children,
  onChange
}) => {
  const {
    services
  } = (0, _public.useKibana)();
  const breadcrumbsRef = (0, _react.useRef)([]);
  const handleChange = breadcrumbs => {
    const newBreadcrumbs = breadcrumbs.map((item, index) => {
      if (index === breadcrumbs.length - 1) {
        return {
          ...item,
          href: undefined
        };
      }
      return item;
    });
    if (onChange) {
      onChange(newBreadcrumbs);
    } else if (services.chrome) {
      const setBreadcrumbs = createBreadcrumbsChangeHandler(services.chrome);
      setBreadcrumbs(newBreadcrumbs);
    }
  };
  return /*#__PURE__*/_react.default.createElement(BreadcrumbsContext.Provider, {
    value: {
      parents: [],
      onMount: breadcrumbs => {
        if (breadcrumbs.length > breadcrumbsRef.current.length) {
          breadcrumbsRef.current = breadcrumbs;
          handleChange(breadcrumbs);
        }
      },
      onUnmount: breadcrumbs => {
        if (breadcrumbs.length < breadcrumbsRef.current.length) {
          breadcrumbsRef.current = breadcrumbs;
          handleChange(breadcrumbs);
        }
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 5
    }
  }, children);
};
exports.BreadcrumbsProvider = BreadcrumbsProvider;
const InnerBreadcrumb = ({
  breadcrumb,
  children
}) => {
  const {
    parents,
    onMount,
    onUnmount
  } = (0, _react.useContext)(BreadcrumbsContext);
  const nextParents = [...parents, breadcrumb];
  (0, _react.useEffect)(() => {
    onMount(nextParents);
    return () => onUnmount(parents);
  }, [breadcrumb.text, breadcrumb.href]); // eslint-disable-line react-hooks/exhaustive-deps

  return /*#__PURE__*/_react.default.createElement(BreadcrumbsContext.Provider, {
    value: {
      parents: nextParents,
      onMount,
      onUnmount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 5
    }
  }, children);
};
exports.InnerBreadcrumb = InnerBreadcrumb;
function getDocTitle(breadcrumbs, maxBreadcrumbs = 2) {
  return breadcrumbs.slice(0, maxBreadcrumbs).reverse().map(({
    text
  }) => text);
}
function createBreadcrumbsChangeHandler(chrome, setBreadcrumbs = chrome.setBreadcrumbs) {
  return breadcrumbs => {
    setBreadcrumbs(breadcrumbs);
    if (breadcrumbs.length === 0) {
      chrome.docTitle.reset();
    } else {
      chrome.docTitle.change(getDocTitle(breadcrumbs));
    }
  };
}