"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QuerySidePanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _searchQueries = require("@kbn/search-queries");
var _reactHookForm = require("react-hook-form");
var _use_source_indices_field = require("../../hooks/use_source_indices_field");
var _use_usage_tracker = require("../../hooks/use_usage_tracker");
var _types = require("../../types");
var _constants = require("../../analytics/constants");
var _search_query = require("./search_query");
var _query_fields_panel = require("./query_fields_panel");
var _chat_prompt = require("./chat_prompt");
var _edit_context_panel = require("../edit_context/edit_context_panel");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_playground/public/components/query_mode/query_side_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const QuerySidePanel = ({
  pageMode,
  executeQuery,
  executeQueryDisabled,
  isLoading
}) => {
  const usageTracker = (0, _use_usage_tracker.useUsageTracker)();
  const {
    fields
  } = (0, _use_source_indices_field.useSourceIndicesFields)();
  const {
    setValue,
    formState
  } = (0, _reactHookForm.useFormContext)();
  const sourceFields = (0, _reactHookForm.useWatch)({
    name: _types.PlaygroundFormFields.sourceFields
  });
  const {
    field: {
      value: queryFields
    }
  } = (0, _reactHookForm.useController)({
    name: _types.PlaygroundFormFields.queryFields
  });
  const {
    field: {
      value: userElasticsearchQuery
    }
  } = (0, _reactHookForm.useController)({
    name: _types.PlaygroundFormFields.userElasticsearchQuery
  });
  const handleSearch = (0, _react.useCallback)(e => {
    e.preventDefault();
    if (executeQueryDisabled) return;
    executeQuery();
  }, [executeQuery, executeQueryDisabled]);
  const updateFields = (0, _react.useCallback)((index, fieldName, checked) => {
    const currentIndexFields = checked ? [...queryFields[index], fieldName] : queryFields[index].filter(field => fieldName !== field);
    const updatedQueryFields = {
      ...queryFields,
      [index]: currentIndexFields
    };
    const updatedQuery = (0, _searchQueries.generateSearchQuery)(updatedQueryFields, sourceFields, fields);
    setValue(_types.PlaygroundFormFields.queryFields, updatedQueryFields, {
      shouldDirty: true,
      shouldValidate: true
    });
    setValue(_types.PlaygroundFormFields.elasticsearchQuery, updatedQuery, {
      shouldDirty: true
    });
    // ensure the userQuery is cleared so it doesn't diverge from the generated query.
    setValue(_types.PlaygroundFormFields.userElasticsearchQuery, null);
    usageTracker === null || usageTracker === void 0 ? void 0 : usageTracker.count(_constants.AnalyticsEvents.queryFieldsUpdated, currentIndexFields.length);
  }, [queryFields, sourceFields, fields, setValue, usageTracker]);
  const hasFieldsError = !!formState.errors[_types.PlaygroundFormFields.queryFields];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    hasShadow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 11
    }
  }, pageMode === _types.PlaygroundPageMode.Search ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.viewQuery.sideBar.query.title",
    defaultMessage: "Query",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.viewQuery.sideBar.prompt.title",
    defaultMessage: "Question",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    grow: false,
    hasShadow: false,
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    onSubmit: handleSearch,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 11
    }
  }, pageMode === _types.PlaygroundPageMode.Search ? /*#__PURE__*/_react.default.createElement(_search_query.SearchQuery, {
    isLoading: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react.default.createElement(_chat_prompt.ChatPrompt, {
    isLoading: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.viewQuery.flyout.table.title",
    defaultMessage: "Fields to search (per index)",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 17
    }
  }))), hasFieldsError && /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.searchPlayground.viewQuery.queryFields.error",
      defaultMessage: "At least one index field must be enabled",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 19
      }
    }),
    type: "warning",
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 15
    }
  }))), Object.entries(fields).map(([index, group]) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: index,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_query_fields_panel.QueryFieldsPanel, {
    index: index,
    indexFields: group,
    updateFields: updateFields,
    queryFields: queryFields,
    customizedQuery: userElasticsearchQuery !== null,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 13
    }
  }))), pageMode === _types.PlaygroundPageMode.Chat && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.searchPlayground.viewQuery.sideBar.context.title",
    defaultMessage: "Context",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_edit_context_panel.EditContextPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 13
    }
  }))));
};
exports.QuerySidePanel = QuerySidePanel;