"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScanUsageResults = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _uiTheme = require("@kbn/ui-theme");
var _react2 = require("@emotion/react");
var _deeplinksSearch = require("@kbn/deeplinks-search");
var _constants = require("@kbn/deeplinks-search/constants");
var _use_kibana = require("../../../../../../hooks/use_kibana");
var _render_message_with_icon = require("./render_message_with_icon");
var i18n = _interopRequireWildcard(require("../delete/confirm_delete_endpoint/translations"));
var _list_usage_results = require("./list_usage_results");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_inference_endpoints/public/components/all_inference_endpoints/render_table_columns/render_actions/actions/component/scan_usage_results.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ScanUsageResults = ({
  list,
  ignoreWarningCheckbox,
  onIgnoreWarningCheckboxChange
}) => {
  const {
    services: {
      application,
      serverless
    }
  } = (0, _use_kibana.useKibana)();
  const handleNavigateToIndexManagement = () => {
    if (serverless) {
      application === null || application === void 0 ? void 0 : application.navigateToApp(_constants.SEARCH_INDICES, {
        openInNewTab: true
      });
    } else {
      application === null || application === void 0 ? void 0 : application.navigateToApp(_deeplinksSearch.ENTERPRISE_SEARCH_CONTENT_APP_ID, {
        path: `search_indices`,
        openInNewTab: true
      });
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_render_message_with_icon.RenderMessageWithIcon, {
    icon: "warning",
    color: "danger",
    label: i18n.POTENTIAL_FAILURE_LABEL,
    labelColor: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    gutterSize: "s",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    css: (0, _react2.css)`
                      font-weight: ${_uiTheme.euiThemeVars.euiCodeFontWeightBold};
                    `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 21
    }
  }, i18n.COUNT_USAGE_LABEL(list.length)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: handleNavigateToIndexManagement,
    iconType: "popout",
    iconSide: "right",
    iconSize: "s",
    flush: "both",
    color: "text",
    "aria-label": i18n.OPEN_INDEX_MANAGEMENT,
    "data-test-subj": "inferenceManagementOpenIndexManagement",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 21
    }
  }, i18n.OPEN_INDEX_MANAGEMENT))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_list_usage_results.ListUsageResults, {
    list: list,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 15
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    "data-test-subj": "warningCheckbox",
    id: 'ignoreWarningCheckbox',
    label: i18n.IGNORE_POTENTIAL_ERRORS_LABEL,
    checked: ignoreWarningCheckbox,
    onChange: e => onIgnoreWarningCheckboxChange(e.target.checked),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 11
    }
  }))));
};
exports.ScanUsageResults = ScanUsageResults;