"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionButtons = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _shared_imports = require("../../../../../shared_imports");
var _request_flyout = require("./request_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/remote_clusters/public/application/sections/components/remote_cluster_config_steps/components/action_buttons.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ActionButtons = ({
  showRequest,
  handleNext,
  disabled,
  isSaving,
  onBack,
  confirmFormText,
  backFormText,
  cluster,
  nextButtonTestSubj,
  backButtonTestSubj,
  previousClusterMode
}) => {
  const [isRequestVisible, setIsRequestVisible] = (0, _react.useState)(false);
  const toggleRequest = (0, _react.useCallback)(() => {
    setIsRequestVisible(prev => !prev);
  }, []);
  return /*#__PURE__*/_react.default.createElement(_shared_imports.EuiFlexGroup, {
    wrap: true,
    justifyContent: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.EuiButton, {
    color: "primary",
    fill: true,
    onClick: handleNext,
    disabled: disabled,
    isLoading: isSaving,
    "data-test-subj": nextButtonTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 13
    }
  }, confirmFormText)), /*#__PURE__*/_react.default.createElement(_shared_imports.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 11
    }
  }, onBack && /*#__PURE__*/_react.default.createElement(_shared_imports.EuiButtonEmpty, {
    color: "primary",
    onClick: onBack,
    "data-test-subj": backButtonTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 15
    }
  }, backFormText)))), /*#__PURE__*/_react.default.createElement(_shared_imports.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }, showRequest && /*#__PURE__*/_react.default.createElement(_shared_imports.EuiFlexGroup, {
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.EuiButtonEmpty, {
    onClick: toggleRequest,
    "data-test-subj": "remoteClustersRequestButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 15
    }
  }, isRequestVisible ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.remoteClusters.remoteClusterForm.hideRequestButtonLabel",
    defaultMessage: "Hide request",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 19
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.remoteClusters.remoteClusterForm.showRequestButtonLabel",
    defaultMessage: "Show request",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 19
    }
  }))))), isRequestVisible && cluster ? /*#__PURE__*/_react.default.createElement(_request_flyout.RequestFlyout, {
    cluster: cluster,
    close: () => setIsRequestVisible(false),
    previousClusterMode: previousClusterMode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  }) : null);
};
exports.ActionButtons = ActionButtons;