"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlameGraphTooltip = FlameGraphTooltip;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react2 = _interopRequireDefault(require("react"));
var _use_calculate_impact_estimates = require("../../hooks/use_calculate_impact_estimates");
var _as_cost = require("../../utils/formatters/as_cost");
var _as_percentage = require("../../utils/formatters/as_percentage");
var _as_weight = require("../../utils/formatters/as_weight");
var _as_integer = require("../../utils/formatters/as_integer");
var _cpu_label_with_hint = require("../cpu_label_with_hint");
var _tooltip_row = require("./tooltip_row");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/profiling/public/components/flamegraph/flamegraph_tooltip.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function FlameGraphTooltip({
  annualCO2KgsInclusive,
  annualCostsUSDInclusive,
  baselineScaleFactor,
  comparisonAnnualCO2KgsInclusive,
  comparisonAnnualCostsUSDInclusive,
  comparisonCountExclusive,
  comparisonCountInclusive,
  comparisonScaleFactor,
  comparisonTotalSamples,
  comparisonTotalSeconds,
  countExclusive,
  countInclusive,
  inline,
  isRoot,
  label,
  onShowMoreClick,
  parentLabel,
  totalSamples,
  totalSeconds
}) {
  const theme = (0, _eui.useEuiTheme)();
  const calculateImpactEstimates = (0, _use_calculate_impact_estimates.useCalculateImpactEstimate)();
  const impactEstimates = calculateImpactEstimates({
    countExclusive,
    countInclusive,
    totalSamples,
    totalSeconds
  });
  const comparisonImpactEstimates = (0, _lodash.isNumber)(comparisonCountExclusive) && (0, _lodash.isNumber)(comparisonCountInclusive) && (0, _lodash.isNumber)(comparisonTotalSamples) && (0, _lodash.isNumber)(comparisonTotalSeconds) ? calculateImpactEstimates({
    countExclusive: comparisonCountExclusive,
    countInclusive: comparisonCountInclusive,
    totalSamples: comparisonTotalSamples,
    totalSeconds: comparisonTotalSeconds
  }) : undefined;
  return /*#__PURE__*/_react2.default.createElement(_charts.TooltipContainer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    size: "xxxs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 15
    }
  }, label))), /*#__PURE__*/_react2.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    style: {
      background: theme.euiTheme.border.color
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 11
    }
  }), inline && /*#__PURE__*/_react2.default.createElement(_eui.EuiCallOut, {
    css: (0, _react.css)`
                p {
                  display: flex;
                }
              `,
    color: "primary",
    title: /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.profiling.flameGraphTooltip.inlineCallout', {
      defaultMessage: 'This function has been inlined by {parentLabel}',
      values: {
        parentLabel
      }
    })),
    size: "s",
    iconType: "info",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 13
    }
  }), isRoot === false && /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_tooltip_row.TooltipRow, {
    label: /*#__PURE__*/_react2.default.createElement(_cpu_label_with_hint.CPULabelWithHint, {
      type: "total",
      labelSize: "xs",
      iconSize: "s",
      labelStyle: {
        fontWeight: 'bold'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 19
      }
    }),
    value: impactEstimates.totalCPU.percentage,
    comparison: comparisonImpactEstimates === null || comparisonImpactEstimates === void 0 ? void 0 : comparisonImpactEstimates.totalCPU.percentage,
    formatValue: _as_percentage.asPercentage,
    showDifference: true,
    formatDifferenceAsPercentage: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react2.default.createElement(_tooltip_row.TooltipRow, {
    label: /*#__PURE__*/_react2.default.createElement(_cpu_label_with_hint.CPULabelWithHint, {
      type: "self",
      labelSize: "xs",
      iconSize: "s",
      labelStyle: {
        fontWeight: 'bold'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 19
      }
    }),
    value: impactEstimates.selfCPU.percentage,
    comparison: comparisonImpactEstimates === null || comparisonImpactEstimates === void 0 ? void 0 : comparisonImpactEstimates.selfCPU.percentage,
    showDifference: true,
    formatDifferenceAsPercentage: true,
    formatValue: _as_percentage.asPercentage,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react2.default.createElement(_tooltip_row.TooltipRow, {
    label: _i18n.i18n.translate('xpack.profiling.flameGraphTooltip.samplesLabel', {
      defaultMessage: `Samples`
    }),
    value: (0, _lodash.isNumber)(baselineScaleFactor) ? countInclusive * baselineScaleFactor : countInclusive,
    comparison: (0, _lodash.isNumber)(comparisonCountInclusive) && (0, _lodash.isNumber)(comparisonScaleFactor) ? comparisonCountInclusive * comparisonScaleFactor : undefined,
    formatValue: _as_integer.asInteger,
    showDifference: true,
    formatDifferenceAsPercentage: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react2.default.createElement(_tooltip_row.TooltipRow, {
    label: _i18n.i18n.translate('xpack.profiling.flameGraphTooltip.annualizedCo2', {
      defaultMessage: `Annualized CO2`
    }),
    value: annualCO2KgsInclusive,
    comparison: comparisonAnnualCO2KgsInclusive,
    formatValue: value => (0, _as_weight.asWeight)(value, 'kgs'),
    showDifference: true,
    formatDifferenceAsPercentage: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react2.default.createElement(_tooltip_row.TooltipRow, {
    label: _i18n.i18n.translate('xpack.profiling.flameGraphTooltip.annualizedDollarCost', {
      defaultMessage: `Annualized dollar cost`
    }),
    value: annualCostsUSDInclusive,
    comparison: comparisonAnnualCostsUSDInclusive,
    formatValue: _as_cost.asCost,
    showDifference: true,
    formatDifferenceAsPercentage: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 11
    }
  }), onShowMoreClick && /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    style: {
      background: theme.euiTheme.border.color
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "profilingFlameGraphTooltipButton",
    size: "s",
    iconType: "inspect",
    onClick: onShowMoreClick,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.profiling.flameGraphTooltip.showMoreButton', {
    defaultMessage: `Show more information`
  })))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
    type: "info",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 21
    }
  }, _i18n.i18n.translate('xpack.profiling.flameGraphTooltip.rightClickTip', {
    defaultMessage: `Right-click to pin tooltip`
  })))))))));
}