"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeoutField = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _reactHookForm = require("react-hook-form");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/form/timeout_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TimeoutFieldComponent = ({
  euiFieldProps
}) => {
  const {
    field: {
      onChange,
      value
    },
    fieldState: {
      error
    }
  } = (0, _reactHookForm.useController)({
    name: 'timeout',
    defaultValue: _constants.QUERY_TIMEOUT.DEFAULT,
    rules: {
      validate: currentValue => {
        if (currentValue < _constants.QUERY_TIMEOUT.DEFAULT || isNaN(currentValue)) {
          return _i18n.i18n.translate('xpack.osquery.pack.queryFlyoutForm.timeoutFieldMinNumberError', {
            defaultMessage: 'The timeout value must be {timeoutInSeconds} seconds or higher.',
            values: {
              timeoutInSeconds: _constants.QUERY_TIMEOUT.DEFAULT
            }
          });
        }
        if (currentValue > _constants.QUERY_TIMEOUT.MAX) {
          return _i18n.i18n.translate('xpack.osquery.pack.queryFlyoutForm.timeoutFieldMaxNumberError', {
            defaultMessage: 'The timeout value must be {timeoutInSeconds} seconds or or lower. ',
            values: {
              timeoutInSeconds: _constants.QUERY_TIMEOUT.MAX
            }
          });
        }
      }
    }
  });
  const handleChange = (0, _react.useCallback)(e => {
    const numberValue = parseInt(e.target.value, 10);
    onChange(numberValue);
  }, [onChange]);
  const hasError = (0, _react.useMemo)(() => !!(error !== null && error !== void 0 && error.message), [error === null || error === void 0 ? void 0 : error.message]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      alignItems: "flexEnd",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.osquery.liveQuery.timeout",
      defaultMessage: "Timeout",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.osquery.liveQuery.timeoutHint', {
        defaultMessage: 'The default and minimum timeout period is 60 seconds. Increase this value if your query needs more time to run.'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 13
      }
    }))),
    fullWidth: true,
    error: error === null || error === void 0 ? void 0 : error.message,
    isInvalid: hasError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, (0, _extends2.default)({
    isInvalid: hasError,
    value: value,
    onChange: handleChange,
    fullWidth: true,
    type: "number",
    "data-test-subj": "timeout-input",
    name: "timeout",
    min: _constants.QUERY_TIMEOUT.DEFAULT,
    max: _constants.QUERY_TIMEOUT.MAX,
    defaultValue: _constants.QUERY_TIMEOUT.DEFAULT,
    step: 1,
    append: "seconds"
  }, euiFieldProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  })));
};
const TimeoutField = exports.TimeoutField = /*#__PURE__*/_react.default.memo(TimeoutFieldComponent, _fastDeepEqual.default);