"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OsqueryEditor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _codeEditor = require("@kbn/code-editor");
var _monaco = require("@kbn/monaco");
var _osquery_highlight_rules = require("./osquery_highlight_rules");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/editor/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const editorOptions = {
  theme: 'osquery',
  automaticLayout: true
};
const MIN_HEIGHT = 100;
const OsqueryEditorComponent = ({
  defaultValue,
  onChange,
  commands
}) => {
  const [editorValue, setEditorValue] = (0, _react.useState)(defaultValue !== null && defaultValue !== void 0 ? defaultValue : '');
  const [height, setHeight] = (0, _react.useState)(MIN_HEIGHT);
  (0, _useDebounce.default)(() => {
    onChange(editorValue);
  }, 500, [editorValue]);
  (0, _react.useEffect)(() => setEditorValue(defaultValue), [defaultValue]);
  (0, _react.useEffect)(() => {
    const disposable = (0, _osquery_highlight_rules.initializeOsqueryEditor)();
    return () => {
      disposable === null || disposable === void 0 ? void 0 : disposable.dispose();
    };
  }, []);
  const editorDidMount = (0, _react.useCallback)(editor => {
    const minHeight = 100;
    const maxHeight = 1000;
    commands === null || commands === void 0 ? void 0 : commands.map(command => {
      if (command.name === 'submitOnCmdEnter') {
        // on CMD/CTRL + Enter submit the query
        // eslint-disable-next-line no-bitwise
        editor.addCommand(_monaco.monaco.KeyMod.CtrlCmd | _monaco.monaco.KeyCode.Enter, command.exec);
      }
    });
    const updateHeight = () => {
      const contentHeight = Math.min(maxHeight, Math.max(minHeight, editor.getContentHeight()));
      setHeight(contentHeight);
    };
    editor.onDidContentSizeChange(updateHeight);
  }, [commands]);
  return /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    languageId: 'sql',
    value: editorValue,
    onChange: setEditorValue,
    options: editorOptions,
    height: height + 'px',
    width: "100%",
    editorDidMount: editorDidMount,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 5
    }
  });
};
const OsqueryEditor = exports.OsqueryEditor = /*#__PURE__*/_react.default.memo(OsqueryEditorComponent);