"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNumOverlapped = exports.getNumAgentsInGrouping = exports.generateColorPicker = exports.generateAgentSelection = exports.generateAgentCheck = void 0;
var _eui = require("@elastic/eui");
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getNumOverlapped = ({
  policy = {},
  platform = {}
}, overlap) => {
  let sum = 0;
  Object.keys(platform).forEach(plat => {
    var _overlap$plat;
    const policies = (_overlap$plat = overlap[plat]) !== null && _overlap$plat !== void 0 ? _overlap$plat : {};
    Object.keys(policy).forEach(pol => {
      var _policies$pol;
      sum += (_policies$pol = policies[pol]) !== null && _policies$pol !== void 0 ? _policies$pol : 0;
    });
  });
  return sum;
};
exports.getNumOverlapped = getNumOverlapped;
const generateColorPicker = () => {
  const visColorsBehindText = (0, _eui.euiPaletteColorBlindBehindText)();
  const typeColors = new Map();
  return type => {
    if (!typeColors.has(type)) {
      typeColors.set(type, visColorsBehindText[typeColors.size]);
    }
    return typeColors.get(type);
  };
};
exports.generateColorPicker = generateColorPicker;
const getNumAgentsInGrouping = selectedGroups => {
  let sum = 0;
  Object.keys(selectedGroups).forEach(g => {
    const group = selectedGroups[g];
    sum += Object.keys(group).reduce((acc, k) => acc + group[k], 0);
  });
  return sum;
};
exports.getNumAgentsInGrouping = getNumAgentsInGrouping;
const generateAgentCheck = selectedGroups => ({
  groups
}) => Object.keys(groups).map(group => {
  const selectedGroup = selectedGroups[group];
  const agentGroup = groups[group];

  // check if the agent platform/policy is selected
  return selectedGroup[agentGroup];
}).every(a => !a);
exports.generateAgentCheck = generateAgentCheck;
const generateAgentSelection = selection => {
  const newAgentSelection = {
    agents: [],
    allAgentsSelected: false,
    platformsSelected: [],
    policiesSelected: [],
    offlineAgentsSelected: false
  };
  // parse through the selections to be able to determine how many are actually selected
  const selectedAgents = [];
  const selectedGroups = {
    policy: {},
    platform: {}
  };
  for (const opt of selection) {
    var _opt$value, _ref, _opt$key, _opt$value2;
    const groupType = (_opt$value = opt.value) === null || _opt$value === void 0 ? void 0 : _opt$value.groupType;
    // best effort to get the proper identity
    const key = (_ref = (_opt$key = opt.key) !== null && _opt$key !== void 0 ? _opt$key : (_opt$value2 = opt.value) === null || _opt$value2 === void 0 ? void 0 : _opt$value2.id) !== null && _ref !== void 0 ? _ref : opt.label;
    let value;
    switch (groupType) {
      case _types.AGENT_GROUP_KEY.All:
        newAgentSelection.allAgentsSelected = true;
        break;
      case _types.AGENT_GROUP_KEY.Platform:
        value = opt.value;
        if (!newAgentSelection.allAgentsSelected) {
          // we don't need to calculate diffs when all agents are selected
          selectedGroups.platform[key] = value.size;
        }
        newAgentSelection.platformsSelected.push(key);
        break;
      case _types.AGENT_GROUP_KEY.Policy:
        value = opt.value;
        if (!newAgentSelection.allAgentsSelected) {
          // we don't need to calculate diffs when all agents are selected
          selectedGroups.policy[key] = value.size;
        }
        newAgentSelection.policiesSelected.push(key);
        break;
      case _types.AGENT_GROUP_KEY.Agent:
        value = opt.value;
        if (!newAgentSelection.allAgentsSelected) {
          // we don't need to count how many agents are selected if they are all selected
          selectedAgents.push(value);
        }
        newAgentSelection.agents.push(key);
        if (opt.disabled) {
          newAgentSelection.offlineAgentsSelected = true;
        }
        break;
      default:
        // this should never happen!
        // eslint-disable-next-line no-console
        console.error(`unknown group type ${groupType}`);
    }
  }
  return {
    newAgentSelection,
    selectedGroups,
    selectedAgents
  };
};
exports.generateAgentSelection = generateAgentSelection;