"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RoundIcon = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_rounds/round_icon.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const labels = {
  error: _i18n.i18n.translate('xpack.onechat.round.icon.error', {
    defaultMessage: 'Round has an error'
  }),
  loading: _i18n.i18n.translate('xpack.onechat.round.icon.loading', {
    defaultMessage: 'Round is loading'
  }),
  content: _i18n.i18n.translate('xpack.onechat.round.icon.content', {
    defaultMessage: 'Round content'
  })
};
const RoundIcon = ({
  isLoading,
  isError
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const loadingStyles = (0, _react2.css)`
    inline-size: ${euiTheme.size.xl};
    block-size: ${euiTheme.size.xl};
    display: flex;
    align-items: center;
    justify-content: center;
  `;
  if (isError) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
      name: labels.error,
      "aria-label": labels.error,
      iconType: "warningFilled",
      iconColor: euiTheme.colors.textDanger,
      iconSize: "m",
      color: euiTheme.colors.backgroundBaseDanger,
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 7
      }
    });
  }
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement("div", {
      css: loadingStyles,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingElastic, {
      size: "l",
      "aria-label": labels.loading,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
    name: labels.content,
    "aria-label": labels.content,
    iconType: "logoElastic",
    iconSize: "l",
    color: euiTheme.colors.backgroundBasePlain,
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  });
};
exports.RoundIcon = RoundIcon;