"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConversationInputTextArea = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireWildcard(require("react"));
var _use_conversation_id = require("../../../hooks/use_conversation_id");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_input/conversation_input_text_area.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const inputContainerStyles = (0, _react.css)`
  display: flex;
  flex-direction: column;
  .euiFormControlLayout--euiTextArea,
  .euiFormControlLayout__childrenWrapper {
    height: 100%;
  }
  /* Using ID for high specificity selector */
  #conversationInput {
    border: none;
    box-shadow: none;
    outline: none;
    background-image: none;
  }
`;
const textareaStyles = (0, _react.css)`
  height: 100%;
  padding: 0;
`;
const ConversationInputTextArea = ({
  input,
  setInput,
  onSubmit,
  disabled,
  agentId
}) => {
  const conversationId = (0, _use_conversation_id.useConversationId)();
  const textAreaRef = (0, _react2.useRef)(null);
  (0, _react2.useEffect)(() => {
    // Auto focus the text area when the user switches conversations
    setTimeout(() => {
      var _textAreaRef$current;
      (_textAreaRef$current = textAreaRef.current) === null || _textAreaRef$current === void 0 ? void 0 : _textAreaRef$current.focus();
    }, 200);
  }, [conversationId]);
  const disabledPlaceholder = _i18n.i18n.translate('xpack.onechat.conversationInputForm.disabledPlaceholder', {
    defaultMessage: 'Agent "{agentId}" has been deleted. Please start a new conversation.',
    values: {
      agentId
    }
  });
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: inputContainerStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTextArea, {
    id: "conversationInput",
    name: _i18n.i18n.translate('xpack.onechat.conversationInputForm.textArea.name', {
      defaultMessage: 'Conversation input'
    }),
    css: textareaStyles,
    "data-test-subj": "onechatAppConversationInputFormTextArea",
    value: input,
    onChange: event => {
      setInput(event.currentTarget.value);
    },
    onKeyDown: event => {
      if (!event.shiftKey && event.key === _eui.keys.ENTER) {
        event.preventDefault();
        onSubmit();
      }
    },
    placeholder: disabled ? disabledPlaceholder : _i18n.i18n.translate('xpack.onechat.conversationInputForm.placeholder', {
      defaultMessage: 'Ask anything'
    }),
    rows: 1,
    inputRef: textAreaRef,
    fullWidth: true,
    resize: "none",
    disabled: disabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }));
};
exports.ConversationInputTextArea = ConversationInputTextArea;