"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConversationRight = exports.ConversationLeft = exports.ConversationGrid = exports.ConversationContentWithMargins = exports.ConversationContent = exports.ConversationCenter = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _conversation_grid = require("./conversation_grid.styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_grid.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// Main grid

const ConversationGrid = ({
  children,
  className
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const sideColumnWidth = `minmax(calc(${euiTheme.size.xxl} * 2), 1fr)`;
  const contentMarginWidth = euiTheme.size.l;
  const centerColumnWidth = (0, _conversation_grid.useConversationGridCenterColumnWidth)();
  const gridStyles = (0, _react.css)`
    display: grid;
    grid-template-columns:
      ${sideColumnWidth} ${contentMarginWidth} minmax(auto, ${centerColumnWidth})
      ${contentMarginWidth} ${sideColumnWidth};
    align-items: center;
    width: 100%;
  `;
  return /*#__PURE__*/_react2.default.createElement("div", {
    css: gridStyles,
    className: className,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  }, children);
};
exports.ConversationGrid = ConversationGrid;
// Left side column

const leftContainerStyles = (0, _react.css)`
  grid-column: 1;
`;
const ConversationLeft = ({
  children,
  className
}) => {
  return /*#__PURE__*/_react2.default.createElement("div", {
    css: leftContainerStyles,
    className: className,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }, children);
};

// Center column without the margins
exports.ConversationLeft = ConversationLeft;
const centerContainerStyles = (0, _react.css)`
  grid-column: 3;
`;
const ConversationCenter = ({
  children,
  className
}) => {
  return /*#__PURE__*/_react2.default.createElement("div", {
    css: centerContainerStyles,
    className: className,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 5
    }
  }, children);
};

// Right side column
exports.ConversationCenter = ConversationCenter;
const rightContainerStyles = (0, _react.css)`
  grid-column: 5;
`;
const ConversationRight = ({
  children,
  className
}) => {
  return /*#__PURE__*/_react2.default.createElement("div", {
    css: rightContainerStyles,
    className: className,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 5
    }
  }, children);
};

// Shorthand for using centered content in the grid
exports.ConversationRight = ConversationRight;
const ConversationContent = ({
  children,
  className
}) => {
  return /*#__PURE__*/_react2.default.createElement(ConversationGrid, {
    className: className,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(ConversationCenter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 7
    }
  }, children));
};

// Shorthand for using centered content with margins in the grid
exports.ConversationContent = ConversationContent;
const contentWithMarginsStyles = (0, _react.css)`
  grid-column: 2 / 5;
`;
const ConversationContentWithMargins = ({
  children,
  className
}) => {
  return /*#__PURE__*/_react2.default.createElement(ConversationGrid, {
    className: className,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement("div", {
    css: contentWithMarginsStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 7
    }
  }, children));
};
exports.ConversationContentWithMargins = ConversationContentWithMargins;