"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccessBoundary = void 0;
var _react = _interopRequireDefault(require("react"));
var _use_onechat_service = require("../../hooks/use_onechat_service");
var _add_llm_connection_prompt = require("./prompts/add_llm_connection_prompt");
var _upgrade_license_prompt = require("./prompts/upgrade_license_prompt");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/access/access_boundary.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AccessBoundary = ({
  children
}) => {
  const {
    accessChecker
  } = (0, _use_onechat_service.useOnechatServices)();
  const {
    hasRequiredLicense,
    hasLlmConnector
  } = accessChecker.getAccess();
  if (!hasRequiredLicense) {
    return /*#__PURE__*/_react.default.createElement(_upgrade_license_prompt.UpgradeLicensePrompt, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 18,
        columnNumber: 12
      }
    });
  }
  if (!hasLlmConnector) {
    return /*#__PURE__*/_react.default.createElement(_add_llm_connection_prompt.AddLlmConnectionPrompt, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 22,
        columnNumber: 12
      }
    });
  }
  return children;
};
exports.AccessBoundary = AccessBoundary;