"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SectionContainer = SectionContainer;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _kibana_react = require("../../../../utils/kibana_react");
var _error_panel = require("./error_panel/error_panel");
var _experimental_badge = require("../../../../components/experimental_badge");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/pages/overview/components/sections/section_container.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function SectionContainer({
  title,
  appLink,
  children,
  hasError,
  initialIsOpen = true,
  showExperimentalBadge = false
}) {
  const {
    http
  } = (0, _kibana_react.useKibana)().services;
  const euiAccordionId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'euiAccordion'
  });
  const prependBasePath = (appLink === null || appLink === void 0 ? void 0 : appLink.prependBasePath) !== undefined ? appLink === null || appLink === void 0 ? void 0 : appLink.prependBasePath : true;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    initialIsOpen: initialIsOpen,
    id: euiAccordionId,
    buttonContentClassName: "accordion-button",
    "data-test-subj": `accordion-${title}`,
    buttonContent: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      responsive: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement("h5", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 19
      }
    }, title))), showExperimentalBadge && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_experimental_badge.ExperimentalBadge, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 19
      }
    })))),
    extraAction: (appLink === null || appLink === void 0 ? void 0 : appLink.href) && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "o11ySectionContainerButton",
      iconType: 'sortRight',
      size: "xs",
      color: "text",
      href: prependBasePath ? http.basePath.prepend(appLink.href) : appLink.href,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 13
      }
    }, appLink.label),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 11
    }
  }, hasError ? /*#__PURE__*/_react.default.createElement(_error_panel.ErrorPanel, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 50
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children)))));
}