"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusBar = StatusBar;
var _react = _interopRequireDefault(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _alert_lifecycle_status_badge = require("@kbn/alerts-ui-shared/src/alert_lifecycle_status_badge");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _react2 = require("@emotion/react");
var _public = require("@kbn/observability-shared-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _formatters = require("../../../../common/utils/formatters");
var _case_links = require("./case_links");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/pages/alert_details/components/status_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function StatusBar({
  alert,
  alertStatus
}) {
  var _alert$fields$TIMESTA;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const dateFormat = (0, _public2.useUiSetting)('dateFormat');
  const tags = alert === null || alert === void 0 ? void 0 : alert.fields[_ruleDataUtils.TAGS];
  if (!alert) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    gutterSize: "m",
    "data-test-subj": "statusBar",
    wrap: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }, alertStatus && /*#__PURE__*/_react.default.createElement(_alert_lifecycle_status_badge.AlertLifecycleStatusBadge, {
    alertStatus: alertStatus,
    flapping: alert.fields[_ruleDataUtils.ALERT_FLAPPING],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_case_links.CaseLinks, {
    alert: alert,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_public.TagsList, {
    tags: tags,
    ignoreEmpty: true,
    color: "default",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      minWidth: 100
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.pages.alertDetails.pageTitle.triggered",
    defaultMessage: "Triggered",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 13
    }
  }), ":\xA0"), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: (0, _moment.default)(Number(alert.start)).format(dateFormat),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    tabIndex: 0,
    css: (0, _react2.css)`
                font-weight: ${euiTheme.font.weight.semiBold};
              `,
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 13
    }
  }, (0, _moment.default)(Number(alert.start)).locale(_i18n.i18n.getLocale()).fromNow())))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      minWidth: 120
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.pages.alertDetails.pageTitle.duration",
    defaultMessage: "Duration",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 13
    }
  }), ":\xA0"), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    css: (0, _react2.css)`
              font-weight: ${euiTheme.font.weight.semiBold};
            `,
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 11
    }
  }, (0, _formatters.asDuration)(Number(alert.fields[_ruleDataUtils.ALERT_DURATION]))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      minWidth: 240
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.pages.alertDetails.pageTitle.lastStatusUpdate",
    defaultMessage: "Last status update",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 13
    }
  }), ":\xA0"), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: (0, _moment.default)(alert.fields[_ruleDataUtils.TIMESTAMP]).format(dateFormat),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    tabIndex: 0,
    css: (0, _react2.css)`
                font-weight: ${euiTheme.font.weight.semiBold};
              `,
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 13
    }
  }, (0, _moment.default)((_alert$fields$TIMESTA = alert.fields[_ruleDataUtils.TIMESTAMP]) === null || _alert$fields$TIMESTA === void 0 ? void 0 : _alert$fields$TIMESTA.toString()).locale(_i18n.i18n.getLocale()).fromNow())))));
}