"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourceBar = SourceBar;
exports.default = void 0;
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _observabilityGetPaddedAlertTimeRangeUtil = require("@kbn/observability-get-padded-alert-time-range-util");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _groups = require("../../../components/alert_sources/groups");
var _get_sources = require("../../../components/alert_sources/get_sources");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/pages/alert_details/components/source_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SourceBar({
  alert,
  sources = []
}) {
  const [timeRange, setTimeRange] = (0, _react.useState)({
    from: 'now-15m',
    to: 'now'
  });
  const alertStart = alert.fields[_ruleDataUtils.ALERT_START];
  const alertEnd = alert.fields[_ruleDataUtils.ALERT_END];
  const groups = (0, _get_sources.getSources)(alert);
  (0, _react.useEffect)(() => {
    setTimeRange((0, _observabilityGetPaddedAlertTimeRangeUtil.getPaddedAlertTimeRange)(alertStart, alertEnd));
  }, [alertStart, alertEnd]);
  return groups && groups.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "alert-summary-container",
    hasShadow: false,
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    direction: "row",
    wrap: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.alertDetails.sourceBar.source",
    defaultMessage: "Source",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_groups.Groups, {
    groups: groups,
    timeRange: alertEnd ? timeRange : {
      ...timeRange,
      to: 'now'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 11
    }
  }), sources.map((field, idx) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: `sources-${idx}`,
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 17
      }
    }, field.label, ": ", field.value));
  })));
}

// eslint-disable-next-line import/no-default-export
var _default = exports.default = SourceBar;