"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertDetailsRuleFormFlyout = AlertDetailsRuleFormFlyout;
var _react = _interopRequireDefault(require("react"));
var _flyout = require("@kbn/response-ops-rule-form/flyout");
var _kibana_react = require("../../../utils/kibana_react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/pages/alert_details/components/alert_details_rule_form_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function AlertDetailsRuleFormFlyout({
  initialEditStep,
  onUpdate,
  refetch,
  isRuleFormFlyoutOpen,
  setIsRuleFormFlyoutOpen,
  rule
}) {
  const {
    services
  } = (0, _kibana_react.useKibana)();
  if (!isRuleFormFlyoutOpen) return null;
  const {
    triggersActionsUi: {
      ruleTypeRegistry,
      actionTypeRegistry
    }
  } = services;
  return /*#__PURE__*/_react.default.createElement(_flyout.RuleFormFlyout, {
    plugins: {
      ...services,
      ruleTypeRegistry,
      actionTypeRegistry
    },
    id: rule.id,
    onCancel: () => {
      setIsRuleFormFlyoutOpen(false);
    },
    onSubmit: () => {
      onUpdate === null || onUpdate === void 0 ? void 0 : onUpdate();
      refetch();
      setIsRuleFormFlyoutOpen(false);
    },
    initialEditStep: initialEditStep,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  });
}