"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createInstallApiKey = createInstallApiKey;
var _constants = require("@kbn/spaces-plugin/common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Creates a short lived API key with the necessary permissions to install integrations
 */
function createInstallApiKey(name) {
  const timestamp = new Date().toISOString();
  return {
    name: `${name}-${timestamp}`,
    expiration: '1h',
    // This API key is only used for initial setup and should be short lived
    metadata: {
      managed: true,
      application: 'logs'
    },
    kibana_role_descriptors: {
      can_install_integrations: {
        elasticsearch: {},
        kibana: [{
          feature: {
            fleet: ['all'],
            fleetv2: ['all'] // TODO: Remove this once #183020 is resolved
          },
          spaces: [_constants.ALL_SPACES_ID]
        }]
      }
    }
  };
}