"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AutoDetectPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _deeplinksAnalytics = require("@kbn/deeplinks-analytics");
var _common = require("@kbn/observability-shared-plugin/common");
var _common2 = require("@kbn/logs-shared-plugin/common");
var _ebtTools = require("@kbn/ebt-tools");
var _pricing_features = require("../../../../common/pricing_features");
var _get_auto_detect_command = require("./get_auto_detect_command");
var _use_onboarding_flow = require("./use_onboarding_flow");
var _progress_indicator = require("../shared/progress_indicator");
var _accordion_with_icon = require("../shared/accordion_with_icon");
var _empty_prompt = require("../shared/empty_prompt");
var _copy_to_clipboard_button = require("../shared/copy_to_clipboard_button");
var _get_started_panel = require("../shared/get_started_panel");
var _logo_icon = require("../../shared/logo_icon");
var _feedback_buttons = require("../shared/feedback_buttons");
var _supported_integrations_list = require("./supported_integrations_list");
var _use_flow_breadcrumbs = require("../../shared/use_flow_breadcrumbs");
var _use_pricing_feature = require("../shared/use_pricing_feature");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability_onboarding/public/application/quickstart_flows/auto_detect/auto_detect_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AutoDetectPanel = () => {
  (0, _use_flow_breadcrumbs.useFlowBreadcrumb)({
    text: _i18n.i18n.translate('xpack.observability_onboarding.autoDetectPanel.breadcrumbs.autoDetectLabel', {
      defaultMessage: 'Elastic Agent: Logs & Metrics'
    })
  });
  const {
    status,
    data,
    error,
    refetch,
    installedIntegrations
  } = (0, _use_onboarding_flow.useOnboardingFlow)();
  const metricsOnboardingEnabled = (0, _use_pricing_feature.usePricingFeature)(_pricing_features.ObservabilityOnboardingPricingFeature.METRICS_ONBOARDING);
  const command = data ? (0, _get_auto_detect_command.getAutoDetectCommand)({
    scriptDownloadUrl: data.scriptDownloadUrl,
    onboardingId: data.onboardingFlow.id,
    kibanaUrl: data.kibanaUrl,
    installApiKey: data.installApiKey,
    ingestApiKey: data.ingestApiKey,
    elasticAgentVersion: data.elasticAgentVersionInfo.agentVersion,
    metricsEnabled: metricsOnboardingEnabled
  }) : undefined;
  const accordionId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'accordion'
  });
  const {
    onPageReady
  } = (0, _ebtTools.usePerformanceContext)();
  const {
    services: {
      share
    }
  } = (0, _public.useKibana)();
  (0, _react.useEffect)(() => {
    if (data) {
      onPageReady({
        meta: {
          description: `[ttfmp_onboarding] Request to create the onboarding flow succeeded and the flow's UI has rendered`
        }
      });
    }
  }, [data, onPageReady]);
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, {
      onboardingFlowType: "auto-detect",
      error: error,
      onRetryClick: refetch,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 12
      }
    });
  }
  const registryIntegrations = installedIntegrations.filter(integration => integration.installSource === 'registry');
  const customIntegrations = installedIntegrations.filter(integration => integration.installSource === 'custom');
  const logsLocator = share.url.locators.get(_common2.LOGS_LOCATOR_ID);
  const dashboardLocator = share.url.locators.get(_deeplinksAnalytics.DASHBOARD_APP_LOCATOR);
  const assetDetailsLocator = share.url.locators.get(_common.ASSET_DETAILS_LOCATOR_ID);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: [{
      title: _i18n.i18n.translate('xpack.observability_onboarding.autoDetectPanel.runTheCommandOnLabel', {
        defaultMessage: 'Install standalone Elastic Agent on your host'
      }),
      status: status === 'notStarted' ? 'current' : 'complete',
      children: command ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 105,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 106,
          columnNumber: 19
        }
      }, metricsOnboardingEnabled ? _i18n.i18n.translate('xpack.observability_onboarding.autoDetectPanel.p.wellScanYourHostLabel', {
        defaultMessage: "We'll scan your host for logs and metrics, including:"
      }) : _i18n.i18n.translate('xpack.observability_onboarding.logsEssential.autoDetectPanel.p.wellScanYourHostLabel', {
        defaultMessage: "We'll scan your host for logs, including:"
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 122,
          columnNumber: 17
        }
      }), /*#__PURE__*/_react.default.createElement(_supported_integrations_list.SupportedIntegrationsList, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 123,
          columnNumber: 17
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 124,
          columnNumber: 17
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        paddingSize: "m",
        language: "text",
        "data-test-subj": "observabilityOnboardingAutoDetectPanelCodeSnippet",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 126,
          columnNumber: 17
        }
      }, command), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 133,
          columnNumber: 17
        }
      }), /*#__PURE__*/_react.default.createElement(_copy_to_clipboard_button.CopyToClipboardButton, {
        textToCopy: command,
        fill: status === 'notStarted',
        "data-onboarding-id": data === null || data === void 0 ? void 0 : data.onboardingFlow.id,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 134,
          columnNumber: 17
        }
      })) : /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
        lines: 6,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 141,
          columnNumber: 15
        }
      })
    }, {
      title: _i18n.i18n.translate('xpack.observability_onboarding.autoDetectPanel.visualizeYourDataLabel', {
        defaultMessage: 'Visualize your data'
      }),
      status: status === 'dataReceived' ? 'complete' : status === 'awaitingData' || status === 'inProgress' ? 'current' : 'incomplete',
      children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, status === 'dataReceived' ? /*#__PURE__*/_react.default.createElement(_progress_indicator.ProgressIndicator, {
        iconType: "cheer",
        title: _i18n.i18n.translate('xpack.observability_onboarding.autoDetectPanel.yourDataIsReadyToExploreLabel', {
          defaultMessage: 'Your data is ready to explore!'
        }),
        isLoading: false,
        "data-test-subj": "observabilityOnboardingAutoDetectPanelDataReceivedProgressIndicator",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 158,
          columnNumber: 19
        }
      }) : status === 'awaitingData' ? /*#__PURE__*/_react.default.createElement(_progress_indicator.ProgressIndicator, {
        title: _i18n.i18n.translate('xpack.observability_onboarding.autoDetectPanel.installingElasticAgentFlexItemLabel', {
          defaultMessage: 'Waiting for data to arrive...'
        }),
        "data-test-subj": "observabilityOnboardingAutoDetectPanelAwaitingDataProgressIndicator",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 168,
          columnNumber: 19
        }
      }) : status === 'inProgress' ? /*#__PURE__*/_react.default.createElement(_progress_indicator.ProgressIndicator, {
        title: _i18n.i18n.translate('xpack.observability_onboarding.autoDetectPanel.lookingForLogFilesFlexItemLabel', {
          defaultMessage: 'Waiting for installation to complete...'
        }),
        "data-test-subj": "observabilityOnboardingAutoDetectPanelInProgressProgressIndicator",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 176,
          columnNumber: 19
        }
      }) : null, (status === 'awaitingData' || status === 'dataReceived') && installedIntegrations.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 187,
          columnNumber: 21
        }
      }), registryIntegrations.slice()
      /**
       * System integration should always be on top
       */.sort((a, b) => a.pkgName === 'system' ? -1 : 0).map(integration => {
        var _integration$metadata, _logsLocator$getRedir, _data$onboardingFlow;
        let actionLinks;
        switch (integration.pkgName) {
          case 'system':
            actionLinks = metricsOnboardingEnabled && assetDetailsLocator !== undefined ? [{
              id: 'inventory-host-details',
              title: _i18n.i18n.translate('xpack.observability_onboarding.autoDetectPanel.systemOverviewTitle', {
                defaultMessage: 'Overview your system health within the Hosts Inventory'
              }),
              label: _i18n.i18n.translate('xpack.observability_onboarding.autoDetectPanel.systemOverviewLabel', {
                defaultMessage: 'Explore metrics data'
              }),
              href: assetDetailsLocator.getRedirectUrl({
                entityType: 'host',
                entityId: (_integration$metadata = integration.metadata) === null || _integration$metadata === void 0 ? void 0 : _integration$metadata.hostname,
                assetDetails: {
                  dateRange: {
                    from: 'now-15m',
                    to: 'now'
                  }
                }
              })
            }] : [{
              id: 'inventory-host-details',
              title: _i18n.i18n.translate('xpack.observability_onboarding.autoDetectPanel.systemLogsTitle', {
                defaultMessage: 'View and analyze system logs'
              }),
              label: _i18n.i18n.translate('xpack.observability_onboarding.autoDetectPanel.systemLogsLabel', {
                defaultMessage: 'Explore logs'
              }),
              href: (_logsLocator$getRedir = logsLocator === null || logsLocator === void 0 ? void 0 : logsLocator.getRedirectUrl({
                dataViewSpec: {
                  name: integration.pkgName,
                  title: `logs-system*`,
                  timeFieldName: '@timestamp'
                }
              })) !== null && _logsLocator$getRedir !== void 0 ? _logsLocator$getRedir : ''
            }];
            break;
          default:
            actionLinks = dashboardLocator !== undefined && logsLocator !== undefined ? integration.kibanaAssets.filter(asset => asset.type === 'dashboard').map(asset => {
              const dashboard = _use_onboarding_flow.DASHBOARDS[asset.id];
              if (dashboard.type === 'metrics' && !metricsOnboardingEnabled) {
                return {
                  id: asset.id,
                  title: _i18n.i18n.translate('xpack.observability_onboarding.autoDetectPanel.exploreLogsDataDiscoverTitle', {
                    defaultMessage: 'View and analyze your logs'
                  }),
                  label: _i18n.i18n.translate('xpack.observability_onboarding.autoDetectPanel.exploreLogsDiscoverDataLabel', {
                    defaultMessage: 'Explore logs'
                  }),
                  href: logsLocator.getRedirectUrl({
                    dataViewSpec: {
                      name: integration.pkgName,
                      title: `logs-${integration.pkgName}*`,
                      timeFieldName: '@timestamp'
                    }
                  })
                };
              }
              return {
                id: asset.id,
                title: dashboard.type === 'metrics' ? _i18n.i18n.translate('xpack.observability_onboarding.autoDetectPanel.exploreMetricsDataTitle', {
                  defaultMessage: 'Overview your metrics data with this pre-made dashboard'
                }) : _i18n.i18n.translate('xpack.observability_onboarding.autoDetectPanel.exploreLogsDataTitle', {
                  defaultMessage: 'Overview your logs data with this pre-made dashboard'
                }),
                label: dashboard.type === 'metrics' ? _i18n.i18n.translate('xpack.observability_onboarding.autoDetectPanel.exploreMetricsDataLabel', {
                  defaultMessage: 'Explore metrics data'
                }) : _i18n.i18n.translate('xpack.observability_onboarding.autoDetectPanel.exploreLogsDataLabel', {
                  defaultMessage: 'Explore logs data'
                }),
                href: dashboardLocator.getRedirectUrl({
                  dashboardId: asset.id
                })
              };
            }) : [];
        }
        return /*#__PURE__*/_react.default.createElement(_accordion_with_icon.AccordionWithIcon, {
          key: integration.pkgName,
          id: `${accordionId}_${integration.pkgName}`,
          icon: (0, _logo_icon.isSupportedLogo)(integration.pkgName) ? /*#__PURE__*/_react.default.createElement(_logo_icon.LogoIcon, {
            size: "l",
            logo: integration.pkgName,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 338,
              columnNumber: 33
            }
          }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
            type: "desktop",
            size: "l",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 340,
              columnNumber: 33
            }
          }),
          title: _i18n.i18n.translate('xpack.observability_onboarding.autoDetectPanel.h3.getStartedWithNginxLabel', {
            defaultMessage: 'Get started with {title}',
            values: {
              title: integration.title
            }
          }),
          isDisabled: status !== 'dataReceived',
          initialIsOpen: true,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 333,
            columnNumber: 27
          }
        }, /*#__PURE__*/_react.default.createElement(_get_started_panel.GetStartedPanel, {
          onboardingFlowType: "auto-detect",
          dataset: integration.pkgName,
          onboardingId: data === null || data === void 0 ? void 0 : (_data$onboardingFlow = data.onboardingFlow) === null || _data$onboardingFlow === void 0 ? void 0 : _data$onboardingFlow.id,
          telemetryEventContext: {
            autoDetect: {
              installSource: integration.installSource,
              pkgVersion: integration.pkgVersion,
              title: integration.title
            }
          },
          integration: integration.pkgName,
          newTab: true,
          isLoading: status !== 'dataReceived',
          actionLinks: actionLinks,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 353,
            columnNumber: 29
          }
        }));
      }), customIntegrations.length > 0 && /*#__PURE__*/_react.default.createElement(_accordion_with_icon.AccordionWithIcon, {
        id: `${accordionId}_custom`,
        icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "documents",
          size: "l",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 375,
            columnNumber: 31
          }
        }),
        title: _i18n.i18n.translate('xpack.observability_onboarding.autoDetectPanel.h3.getStartedWithlogLabel', {
          defaultMessage: 'Get started with custom .log files'
        }),
        isDisabled: status !== 'dataReceived',
        initialIsOpen: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 373,
          columnNumber: 23
        }
      }, /*#__PURE__*/_react.default.createElement("ul", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 383,
          columnNumber: 25
        }
      }, customIntegrations.map(integration => integration.dataStreams.map(datastream => /*#__PURE__*/_react.default.createElement("li", {
        key: `${integration.pkgName}/${datastream.dataset}`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 386,
          columnNumber: 31
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        "data-test-subj": "observabilityOnboardingAutoDetectPanelButton",
        href: logsLocator === null || logsLocator === void 0 ? void 0 : logsLocator.getRedirectUrl({
          dataViewSpec: {
            name: integration.pkgName,
            title: `${datastream.type}-${datastream.dataset}-*`,
            timeFieldName: '@timestamp'
          }
        }),
        target: "_blank",
        iconType: "document",
        isDisabled: status !== 'dataReceived',
        flush: "left",
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 387,
          columnNumber: 33
        }
      }, integration.pkgName))))))) : null)
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_feedback_buttons.FeedbackButtons, {
    flow: "auto-detect",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 417,
      columnNumber: 7
    }
  }));
};
exports.AutoDetectPanel = AutoDetectPanel;