"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OnboardingFlowForm = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _reactRouterDomV5Compat = require("react-router-dom-v5-compat");
var _public = require("@kbn/kibana-react-plugin/public");
var _ebtTools = require("@kbn/ebt-tools");
var _pricing_features = require("../../../common/pricing_features");
var _package_list_search_form = require("../package_list_search_form/package_list_search_form");
var _use_custom_cards = require("./use_custom_cards");
var _logo_icon = require("../shared/logo_icon");
var _package_list = require("../package_list/package_list");
var _use_pricing_feature = require("../quickstart_flows/shared/use_pricing_feature");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability_onboarding/public/application/onboarding_flow_form/onboarding_flow_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OnboardingFlowForm = () => {
  var _searchParams$get;
  const {
    services: {
      context: {
        isCloud
      }
    }
  } = (0, _public.useKibana)();
  const metricsOnboardingEnabled = (0, _use_pricing_feature.usePricingFeature)(_pricing_features.ObservabilityOnboardingPricingFeature.METRICS_ONBOARDING);
  const applicationUseCaseOption = {
    id: 'application',
    label: _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.euiCheckableCard.applicationLabel', {
      defaultMessage: 'Application'
    }),
    description: _i18n.i18n.translate('xpack.observability_onboarding.onboardingFlowForm.applicationDescription', {
      defaultMessage: 'Monitor your frontend and backend applications, set up synthetic monitors, and track application performance across your stack'
    }),
    logos: ['opentelemetry', 'java', 'ruby', 'dotnet']
  };
  const options = [{
    id: 'host',
    label: _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.euiCheckableCard.hostLabel', {
      defaultMessage: 'Host'
    }),
    description: metricsOnboardingEnabled ? _i18n.i18n.translate('xpack.observability_onboarding.onboardingFlowForm.hostDescription', {
      defaultMessage: 'Track your host and its services by setting up SLOs, receiving alerts, and remediating performance issues'
    }) : _i18n.i18n.translate('xpack.observability_onboarding.logsEssential.onboardingFlowForm.hostDescription', {
      defaultMessage: 'Ingest and analyze logs on your host such as OS, service, application and other logs'
    }),
    logos: ['opentelemetry', 'apache', 'mysql']
  }, {
    id: 'kubernetes',
    label: _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.euiCheckableCard.kubernetesLabel', {
      defaultMessage: 'Kubernetes'
    }),
    description: metricsOnboardingEnabled ? _i18n.i18n.translate('xpack.observability_onboarding.onboardingFlowForm.kubernetesDescription', {
      defaultMessage: 'Monitor your Kubernetes cluster and container workloads using logs, metrics, traces, and profiling data'
    }) : _i18n.i18n.translate('xpack.observability_onboarding.logsEssential.onboardingFlowForm.kubernetesDescription', {
      defaultMessage: 'Observe logs from your Kubernetes environments'
    }),
    logos: ['kubernetes', 'opentelemetry']
  }, ...(metricsOnboardingEnabled ? [applicationUseCaseOption] : []), {
    id: 'cloud',
    label: _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.euiCheckableCard.cloudLabel', {
      defaultMessage: 'Cloud'
    }),
    description: _i18n.i18n.translate('xpack.observability_onboarding.onboardingFlowForm.cloudDescription', {
      defaultMessage: 'Ingest telemetry data from your cloud services to better understand application behavior and ensure service availability'
    }),
    logos: ['azure', 'aws', 'gcp']
  }];
  const radioGroupId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'onboardingCategory'
  });
  const categorySelectorTitleId = (0, _eui.useGeneratedHtmlId)();
  const packageListTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    onPageReady
  } = (0, _ebtTools.usePerformanceContext)();
  const [searchParams, setSearchParams] = (0, _reactRouterDomV5Compat.useSearchParams)();
  const suggestedPackagesRef = (0, _react.useRef)(null);
  const searchResultsRef = (0, _react.useRef)(null);
  const [integrationSearch, setIntegrationSearch] = (0, _react.useState)((_searchParams$get = searchParams.get('search')) !== null && _searchParams$get !== void 0 ? _searchParams$get : '');
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  (0, _react.useEffect)(() => {
    var _searchParams$get2;
    const searchParam = (_searchParams$get2 = searchParams.get('search')) !== null && _searchParams$get2 !== void 0 ? _searchParams$get2 : '';
    if (integrationSearch === searchParam) return;
    const entries = Object.fromEntries(searchParams.entries());
    if (integrationSearch) {
      entries.search = integrationSearch;
    } else {
      delete entries.search;
    }
    setSearchParams(entries, {
      replace: true
    });
  }, [integrationSearch, searchParams, setSearchParams]);
  const createCollectionCardHandler = (0, _react.useCallback)(query => () => {
    setIntegrationSearch(query);
    if (searchResultsRef.current) {
      setTimeout(scrollIntoViewWithOffset, 40,
      // Adding slight delay to ensure DOM is updated before calculating scroll position
      searchResultsRef.current, parseInt(euiTheme.size.l, 10));
    }
  }, [] // eslint-disable-line react-hooks/exhaustive-deps
  );
  (0, _react.useEffect)(() => {
    onPageReady({
      meta: {
        description: '[ttfmp_onboarding] The UI with onboarding categories is rendered'
      }
    });
  }, [onPageReady]);
  const featuredCardsForCategoryMap = {
    host: ['auto-detect-logs', 'otel-logs'],
    kubernetes: ['kubernetes-quick-start', 'otel-kubernetes'],
    application: ['apm-virtual', 'otel-virtual', 'synthetics-virtual'],
    cloud: ['azure-logs-virtual', 'aws-logs-virtual', 'gcp-logs-virtual']
  };
  const customCards = (0, _use_custom_cards.useCustomCards)(createCollectionCardHandler);
  const featuredCardsForCategory = customCards.filter(card => {
    var _featuredCardsForCate;
    const category = searchParams.get('category');
    if (category === null) {
      return false;
    }
    const cardList = (_featuredCardsForCate = featuredCardsForCategoryMap[category]) !== null && _featuredCardsForCate !== void 0 ? _featuredCardsForCate : [];
    return cardList.includes(card.id);
  });

  /**
   * Cloud deployments have the new Firehose quick start
   * flow enabled, so the ond card 'epr:awsfirehose' should
   * not show up in the search results.
   */
  const searchExcludePackageIdList = isCloud ? ['epr:awsfirehose'] : [];
  let isSelectingCategoryWithKeyboard = false;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    id: categorySelectorTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.strong.startCollectingYourDataLabel', {
    defaultMessage: 'What do you want to monitor?'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: metricsOnboardingEnabled ? 2 : 3,
    role: "group",
    "aria-labelledby": categorySelectorTitleId,
    "data-test-subj": "observabilityOnboardingUseCaseGrid",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 7
    }
  }, options.map(option => {
    var _option$logos;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: option.id,
      "data-test-subj": `observabilityOnboardingUseCaseCard-${option.id}` // EuiCheckableCard does not forward `data-test-subj` prop so using parent element instead
      ,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 230,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
      id: `${radioGroupId}_${option.id}`,
      name: radioGroupId,
      label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 239,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 240,
          columnNumber: 21
        }
      }, option.label)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 243,
          columnNumber: 19
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued",
        size: "s",
        css: (0, _react2.css)`
                      flex-grow: 1; // Allow the description to grow to fill the space
                    `,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 244,
          columnNumber: 19
        }
      }, option.description), (option.logos || option.showIntegrationsBadge) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 255,
          columnNumber: 23
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "m",
        responsive: false,
        css: (0, _react2.css)`
                          flex-grow: 0; // Prevent the logos from growing to align to the bottom
                        `,
        "aria-hidden": true // Hide from screen readers as the logos are mainly decorative
        ,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 256,
          columnNumber: 23
        }
      }, (_option$logos = option.logos) === null || _option$logos === void 0 ? void 0 : _option$logos.map(logo => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: logo,
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 265,
          columnNumber: 27
        }
      }, /*#__PURE__*/_react.default.createElement(_logo_icon.LogoIcon, {
        logo: logo,
        size: "l",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 266,
          columnNumber: 29
        }
      }))), option.showIntegrationsBadge && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 270,
          columnNumber: 27
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.observability_onboarding.experimentalOnboardingFlow.form.addIntegrations",
        defaultMessage: "+ Integrations",
        description: "A badge indicating that the user can add additional observability integrations to their deployment via this option",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 271,
          columnNumber: 29
        }
      }))))),
      checked: option.id === searchParams.get('category')
      /**
       * onKeyDown and onKeyUp handlers disable
       * scrolling to the category items when user
       * changes the selected category using keyboard,
       * which prevents our custom scroll behavior
       * from conflicting with browser's native one to
       * put keyboard-focused item into the view.
       */,
      onKeyDown: () => isSelectingCategoryWithKeyboard = true,
      onKeyUp: () => isSelectingCategoryWithKeyboard = false,
      onChange: () => {
        setIntegrationSearch('');
        setSearchParams({
          category: option.id
        }, {
          replace: true
        });
      },
      onClick: () => {
        if (!isSelectingCategoryWithKeyboard && suggestedPackagesRef.current) {
          setTimeout(scrollIntoViewWithOffset, 40,
          // Adding slight delay to ensure DOM is updated before calculating scroll position
          suggestedPackagesRef.current, parseInt(euiTheme.size.l, 10));
        }
      },
      css: (0, _react2.css)`
                flex-grow: 1;

                & > .euiPanel {
                  display: flex;

                  & > .euiCheckableCard__label {
                    display: flex;
                    flex-direction: column;
                  }
                }
              `,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 234,
        columnNumber: 13
      }
    }));
  })), /*#__PURE__*/_react.default.createElement("div", {
    hidden: featuredCardsForCategory.length === 0,
    role: "group",
    "aria-labelledby": packageListTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 325,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 330,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    ref: suggestedPackagesRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 331,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    id: packageListTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 332,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 333,
      columnNumber: 13
    }
  }, searchParams.get('category') === 'kubernetes' ? _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.kubernetesPackagesTitle', {
    defaultMessage: 'Monitor your Kubernetes cluster using:'
  }) : searchParams.get('category') === 'application' ? _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.applicationPackagesTitle', {
    defaultMessage: 'Monitor your Application using:'
  }) : searchParams.get('category') === 'cloud' ? _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.cloudPackagesTitle', {
    defaultMessage: 'Select your Cloud provider:'
  }) : _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.hostPackagesTitle', {
    defaultMessage: 'Monitor your Host using:'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 363,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_package_list.PackageList, {
    list: featuredCardsForCategory,
    showCardLabels: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 364,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement("div", {
    ref: searchResultsRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 368,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 369,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 370,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 371,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability_onboarding.experimentalOnboardingFlow.form.searchPromptText",
    defaultMessage: "Search through other ways of ingesting data:",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 372,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 378,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_package_list_search_form.PackageListSearchForm, {
    searchQuery: integrationSearch,
    setSearchQuery: setIntegrationSearch,
    flowCategory: searchParams.get('category'),
    customCards: customCards.filter(card => !card.isCollectionCard),
    excludePackageIdList: searchExcludePackageIdList,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 379,
      columnNumber: 9
    }
  })));
};
exports.OnboardingFlowForm = OnboardingFlowForm;
function scrollIntoViewWithOffset(element, offset = 0) {
  // Fixed header in Kibana is different height between serverless and stateful so need to calculate dynamically.
  const fixedHeaders = document.querySelectorAll('#globalHeaderBars [data-fixed-header=true]');
  fixedHeaders.forEach(header => {
    offset += header.getBoundingClientRect().height;
  });
  window.scrollTo({
    behavior: 'smooth',
    top: element.getBoundingClientRect().top - document.body.getBoundingClientRect().top - offset
  });
}