"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KnowledgeBaseTab = KnowledgeBaseTab;
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _public = require("@kbn/observability-ai-assistant-plugin/public");
var _hooks = require("@kbn/ai-assistant/src/hooks");
var _knowledge_base_installation_status_panel = require("@kbn/ai-assistant/src/knowledge_base/knowledge_base_installation_status_panel");
var _setting_up_knowledge_base = require("@kbn/ai-assistant/src/knowledge_base/setting_up_knowledge_base");
var _inspect_knowlegde_base_popover = require("@kbn/ai-assistant/src/knowledge_base/inspect_knowlegde_base_popover");
var _knowledge_base_reindexing_callout = require("@kbn/ai-assistant/src/knowledge_base/knowledge_base_reindexing_callout");
var _use_get_knowledge_base_entries = require("../../hooks/use_get_knowledge_base_entries");
var _categorize_entries = require("../../helpers/categorize_entries");
var _knowledge_base_edit_manual_entry_flyout = require("./knowledge_base_edit_manual_entry_flyout");
var _knowledge_base_category_flyout = require("./knowledge_base_category_flyout");
var _knowledge_base_bulk_import_flyout = require("./knowledge_base_bulk_import_flyout");
var _use_kibana = require("../../hooks/use_kibana");
var _knowledge_base_edit_user_instruction_flyout = require("./knowledge_base_edit_user_instruction_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/observability_ai_assistant_management/public/routes/components/knowledge_base_tab.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const fullHeightClassName = (0, _css.css)`
  height: 100%;
`;
const centerMaxWidthClassName = (0, _css.css)`
  text-align: center;
`;
const panelClassname = (0, _css.css)`
  width: 100%;
`;
function KnowledgeBaseTab() {
  var _knowledgeBase$status, _knowledgeBase$status2;
  const {
    uiSettings
  } = (0, _use_kibana.useKibana)().services;
  const dateFormat = uiSettings.get('dateFormat');
  const knowledgeBase = (0, _hooks.useKnowledgeBase)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const columns = [{
    align: 'right',
    width: '40px',
    isExpander: true,
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.span.expandRowLabel', {
      defaultMessage: 'Expand row'
    }))),
    render: category => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        "data-test-subj": "pluginsColumnsButton",
        onClick: () => setSelectedCategory(category),
        "aria-label": category.categoryKey === (selectedCategory === null || selectedCategory === void 0 ? void 0 : selectedCategory.categoryKey) ? 'Collapse' : 'Expand',
        iconType: category.categoryKey === (selectedCategory === null || selectedCategory === void 0 ? void 0 : selectedCategory.categoryKey) ? 'minimize' : 'expand',
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 84,
          columnNumber: 11
        }
      });
    }
  }, {
    field: '',
    name: '',
    render: category => {
      if (category.entries.length === 1 && category.entries[0].role === 'user_entry') {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "documentation",
          color: "primary",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 102,
            columnNumber: 18
          }
        });
      }
      if (category.entries.length === 1 && category.entries[0].role === 'assistant_summarization') {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "sparkles",
          color: "primary",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 108,
            columnNumber: 18
          }
        });
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "logoElastic",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 111,
          columnNumber: 16
        }
      });
    },
    width: '40px'
  }, {
    'data-test-subj': 'knowledgeBaseTableTitleCell',
    field: 'title',
    name: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.kbTab.columns.name', {
      defaultMessage: 'Name'
    }),
    sortable: true
  }, {
    name: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.kbTab.columns.numberOfEntries', {
      defaultMessage: 'Number of entries'
    }),
    width: '140px',
    render: category => {
      if (category.entries.length > 1 && category.entries[0].role === 'elastic') {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 133,
            columnNumber: 18
          }
        }, category.entries.length);
      }
      return null;
    }
  }, {
    'data-test-subj': 'knowledgeBaseTableAuthorCell',
    name: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.kbTab.columns.author', {
      defaultMessage: 'Author'
    }),
    width: '140px',
    render: category => {
      var _category$entries$, _category$entries$$us;
      return (_category$entries$ = category.entries[0]) === null || _category$entries$ === void 0 ? void 0 : (_category$entries$$us = _category$entries$.user) === null || _category$entries$$us === void 0 ? void 0 : _category$entries$$us.name;
    }
  }, {
    field: '@timestamp',
    name: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.kbTab.columns.dateCreated', {
      defaultMessage: 'Date created'
    }),
    width: '140px',
    sortable: true,
    render: timestamp => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 9
      }
    }, (0, _moment.default)(timestamp).format(dateFormat))
  }, {
    name: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.kbTab.columns.type', {
      defaultMessage: 'Type'
    }),
    width: '140px',
    render: category => {
      if (category.entries.length === 1 && category.entries[0].role === 'user_entry') {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: "hollow",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 167,
            columnNumber: 13
          }
        }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.kbTab.columns.manualBadgeLabel', {
          defaultMessage: 'Manual'
        }));
      }
      if (category.entries.length === 1 && category.entries[0].role === 'assistant_summarization') {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: "hollow",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 183,
            columnNumber: 13
          }
        }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.kbTab.columns.assistantSummarization', {
          defaultMessage: 'Assistant'
        }));
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 195,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.columns.systemBadgeLabel', {
        defaultMessage: 'System'
      }));
    }
  }];
  const [selectedCategory, setSelectedCategory] = (0, _react.useState)();
  const [newEntryFlyoutType, setNewEntryFlyoutType] = (0, _react.useState)();
  const [isNewEntryPopoverOpen, setIsNewEntryPopoverOpen] = (0, _react.useState)(false);
  const [isEditUserInstructionFlyoutOpen, setIsEditUserInstructionFlyoutOpen] = (0, _react.useState)(false);
  const [query, setQuery] = (0, _react.useState)('');
  const [sortBy, setSortBy] = (0, _react.useState)('title');
  const [sortDirection, setSortDirection] = (0, _react.useState)('asc');
  const {
    entries = [],
    isLoading,
    refetch
  } = (0, _use_get_knowledge_base_entries.useGetKnowledgeBaseEntries)({
    query,
    sortBy,
    sortDirection,
    inferenceModelState: (_knowledgeBase$status = knowledgeBase.status.value) === null || _knowledgeBase$status === void 0 ? void 0 : _knowledgeBase$status.inferenceModelState
  });
  const categorizedEntries = (0, _categorize_entries.categorizeEntries)({
    entries
  });
  const handleChangeSort = ({
    sort
  }) => {
    if (sort) {
      const {
        field,
        direction
      } = sort;
      setSortBy(field);
      setSortDirection(direction);
    }
  };
  const handleChangeQuery = e => {
    setQuery((e === null || e === void 0 ? void 0 : e.currentTarget.value) || '');
  };
  if (knowledgeBase.status.loading && !knowledgeBase.isPolling) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      direction: "column",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 246,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 247,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xl",
      "data-test-subj": "knowledgeBaseTabLoader",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 248,
        columnNumber: 11
      }
    })));
  }
  if (((_knowledgeBase$status2 = knowledgeBase.status.value) === null || _knowledgeBase$status2 === void 0 ? void 0 : _knowledgeBase$status2.inferenceModelState) === _public.InferenceModelState.READY) {
    var _knowledgeBase$status3;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 257,
        columnNumber: 9
      }
    }, ((_knowledgeBase$status3 = knowledgeBase.status.value) === null || _knowledgeBase$status3 === void 0 ? void 0 : _knowledgeBase$status3.isReIndexing) && /*#__PURE__*/_react.default.createElement(_knowledge_base_reindexing_callout.KnowledgeBaseReindexingCallout, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 258,
        columnNumber: 56
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 260,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 261,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 262,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
      "data-test-subj": "knowledgeBaseTabFieldSearch",
      fullWidth: true,
      placeholder: _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseTab.euiFieldSearch.searchThisLabel', {
        defaultMessage: 'Search for an entry'
      }),
      value: query,
      onChange: handleChangeQuery,
      isClearable: true,
      "aria-label": _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseTab.euiFieldSearch.searchEntriesLabel', {
        defaultMessage: 'Search entries'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 263,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 280,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "knowledgeBaseTabReloadButton",
      color: "success",
      iconType: "refresh",
      onClick: () => refetch(),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 281,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseTab.reloadButtonLabel', {
      defaultMessage: 'Reload'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 293,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "observabilityAiAssistantManagementKnowledgeBaseTabEditInstructionsButton",
      color: "text",
      onClick: () => setIsEditUserInstructionFlyoutOpen(true),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 294,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseTab.editInstructionsButtonLabel', {
      defaultMessage: 'Edit User-specific Prompt'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 306,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      isOpen: isNewEntryPopoverOpen,
      closePopover: () => setIsNewEntryPopoverOpen(false),
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        fill: true,
        "data-test-subj": "knowledgeBaseNewEntryButton",
        iconSide: "right",
        iconType: "arrowDown",
        onClick: () => setIsNewEntryPopoverOpen(prevValue => !prevValue),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 311,
          columnNumber: 21
        }
      }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseTab.newEntryButtonLabel', {
        defaultMessage: 'New entry'
      })),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 307,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
      size: "s",
      items: [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: "singleEntry",
        icon: "document",
        "data-test-subj": "knowledgeBaseSingleEntryContextMenuItem",
        onClick: () => {
          setIsNewEntryPopoverOpen(false);
          setNewEntryFlyoutType('singleEntry');
        },
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 330,
          columnNumber: 23
        }
      }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseTab.singleEntryContextMenuItemLabel', {
        defaultMessage: 'Single entry'
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: "bulkImport",
        icon: "documents",
        "data-test-subj": "knowledgeBaseBulkImportContextMenuItem",
        onClick: () => {
          setIsNewEntryPopoverOpen(false);
          setNewEntryFlyoutType('bulkImport');
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 345,
          columnNumber: 23
        }
      }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseTab.bulkImportContextMenuItemLabel', {
        defaultMessage: 'Bulk import'
      }))],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 327,
        columnNumber: 19
      }
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 366,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
      "data-test-subj": "knowledgeBaseTable",
      columns: columns,
      items: categorizedEntries,
      loading: isLoading,
      sorting: {
        sort: {
          field: sortBy,
          direction: sortDirection
        }
      },
      rowProps: row => ({
        onClick: () => setSelectedCategory(row)
      }),
      onChange: handleChangeSort,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 367,
        columnNumber: 13
      }
    }))), isEditUserInstructionFlyoutOpen ? /*#__PURE__*/_react.default.createElement(_knowledge_base_edit_user_instruction_flyout.KnowledgeBaseEditUserInstructionFlyout, {
      onClose: () => setIsEditUserInstructionFlyoutOpen(false),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 387,
        columnNumber: 11
      }
    }) : null, newEntryFlyoutType === 'singleEntry' ? /*#__PURE__*/_react.default.createElement(_knowledge_base_edit_manual_entry_flyout.KnowledgeBaseEditManualEntryFlyout, {
      onClose: () => setNewEntryFlyoutType(undefined),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 393,
        columnNumber: 11
      }
    }) : null, newEntryFlyoutType === 'bulkImport' ? /*#__PURE__*/_react.default.createElement(_knowledge_base_bulk_import_flyout.KnowledgeBaseBulkImportFlyout, {
      onClose: () => setNewEntryFlyoutType(undefined),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 397,
        columnNumber: 11
      }
    }) : null, selectedCategory ? selectedCategory.entries.length === 1 && (selectedCategory.entries[0].role === 'user_entry' || selectedCategory.entries[0].role === 'assistant_summarization') ? /*#__PURE__*/_react.default.createElement(_knowledge_base_edit_manual_entry_flyout.KnowledgeBaseEditManualEntryFlyout, {
      entry: selectedCategory.entries[0],
      onClose: () => {
        setSelectedCategory(undefined);
        refetch();
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 404,
        columnNumber: 13
      }
    }) : /*#__PURE__*/_react.default.createElement(_knowledge_base_category_flyout.KnowledgeBaseCategoryFlyout, {
      category: selectedCategory,
      onClose: () => setSelectedCategory(undefined),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 412,
        columnNumber: 13
      }
    }) : null);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    direction: "column",
    gutterSize: "none",
    className: fullHeightClassName,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 423,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    css: (0, _css.css)`
          line-height: ${euiTheme.size.l};
        `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 429,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseTab.description', {
    defaultMessage: 'Knowledge Base is a feature that enables the AI Assistant to recall multiple knowledge sources: documents, organizational resources like runbooks, GitHub issues, and internal documentation. It improves response quality with added context for more tailored assistance. '
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: "https://www.elastic.co/docs/solutions/observability/observability-ai-assistant#obs-ai-add-data",
    target: "_blank",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 439,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.knowledgeBaseTab.learnMoreLink', {
    defaultMessage: 'Learn More'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 451,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "xl",
    grow: false,
    className: panelClassname,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 452,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    className: centerMaxWidthClassName,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 453,
      columnNumber: 9
    }
  }, knowledgeBase.isInstalling ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_setting_up_knowledge_base.SettingUpKnowledgeBase, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 456,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_inspect_knowlegde_base_popover.InspectKnowledgeBasePopover, {
    knowledgeBase: knowledgeBase,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 457,
      columnNumber: 15
    }
  })) : /*#__PURE__*/_react.default.createElement(_knowledge_base_installation_status_panel.KnowledgeBaseInstallationStatusPanel, {
    knowledgeBase: knowledgeBase,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 460,
      columnNumber: 13
    }
  }))));
}