"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeseriesVisualization = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _lodash = require("lodash");
var _get_last_value = require("./get_last_value");
var _timeseries_container = require("./timeseries_container");
var _horizontal_legend = require("./horizontal_legend");
var _get_values_for_legend = require("./get_values_for_legend");
var _constants = require("../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/chart/timeseries_visualization.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const rhythmChartStyle = (0, _react2.css)`
  position: relative;
  display: flex;
  flex-direction: column;
  flex: 1 0 auto;
`;
const rhythmChartContentStyle = (0, _react2.css)`
  position: absolute;
  top: 0;
  right: 0;
  bottom: 0;
  left: 0;
  display: flex;
  flex: 1 0 auto;
  flex-direction: column;
`;
const rhythmChartVisualizationStyle = (0, _react2.css)`
  position: relative;
  display: flex;
  flex-direction: column;
  flex: 1 0 auto;

  & > div {
    min-width: 1px;
    width: 100%;
    height: 100%;
  }

  div {
    user-select: none;
  }
`;
class TimeseriesVisualization extends _react.default.Component {
  constructor(props) {
    super(props);
    this.debouncedUpdateLegend = (0, _lodash.debounce)(this.updateLegend, _constants.DEBOUNCE_SLOW_MS);
    this.debouncedUpdateLegend = this.debouncedUpdateLegend.bind(this);
    this.toggleFilter = this.toggleFilter.bind(this);
    const values = this.getLastValues(props);
    this.state = {
      values: {},
      seriesToShow: (0, _lodash.keys)(values),
      ignoreVisibilityUpdates: false
    };
  }
  filterLegend(id) {
    if (!(0, _lodash.has)(this.state.values, id)) {
      return [];
    }
    const notAllShown = (0, _lodash.keys)(this.state.values).length !== this.state.seriesToShow.length;
    const isCurrentlyShown = (0, _lodash.includes)(this.state.seriesToShow, id);
    const seriesToShow = [];
    if (notAllShown && isCurrentlyShown) {
      this.setState({
        ignoreVisibilityUpdates: false,
        seriesToShow: Object.keys(this.state.values)
      });
    } else {
      seriesToShow.push(id);
      this.setState({
        ignoreVisibilityUpdates: true,
        seriesToShow: [id]
      });
    }
    return seriesToShow;
  }
  toggleFilter(_event, id) {
    const seriesToShow = this.filterLegend(id);
    if ((0, _lodash.isFunction)(this.props.onFilter)) {
      this.props.onFilter(seriesToShow);
    }
  }
  getLastValues(props) {
    props = props || this.props;
    const values = {};
    props.series.forEach(row => {
      // we need a valid identifier
      if (!row.id) {
        row.id = row.label;
      }
      values[row.id] = (0, _get_last_value.getLastValue)(row.data);
    });
    return values;
  }
  updateLegend(pos, item) {
    const values = {};
    if (pos) {
      // callback
      const setValueCallback = (seriesId, value) => {
        values[seriesId] = value;
      };
      if (item) {
        (0, _get_values_for_legend.getValuesForSeriesIndex)(this.props.series, item.dataIndex, setValueCallback);
      } else {
        (0, _get_values_for_legend.getValuesByX)(this.props.series, pos.x, setValueCallback);
      }
    } else {
      (0, _lodash.assign)(values, this.getLastValues());
    }
    this.setState({
      values
    });
  }
  UNSAFE_componentWillReceiveProps(props) {
    const values = this.getLastValues(props);
    const currentKeys = (0, _lodash.keys)(this.state.values);
    const valueKeys = (0, _lodash.keys)(values);
    const diff = (0, _lodash.difference)(valueKeys, currentKeys);
    const nextState = {
      values: values
    };
    if (diff.length && !this.state.ignoreVisibilityUpdates) {
      nextState.seriesToShow = valueKeys;
    }
    this.setState(nextState);
  }
  render() {
    const legend = this.props.hasLegend ? /*#__PURE__*/_react.default.createElement(_horizontal_legend.HorizontalLegend, (0, _extends2.default)({
      seriesFilter: this.state.seriesToShow,
      seriesValues: this.state.values,
      onToggle: this.toggleFilter
    }, this.props, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 7
      }
    })) : null;
    return /*#__PURE__*/_react.default.createElement("div", {
      css: rhythmChartStyle,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      css: rhythmChartContentStyle,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      css: rhythmChartVisualizationStyle,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_timeseries_container.TimeseriesContainer, (0, _extends2.default)({
      seriesToShow: this.state.seriesToShow,
      updateLegend: this.debouncedUpdateLegend
    }, this.props, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 13
      }
    }))), legend));
  }
}
exports.TimeseriesVisualization = TimeseriesVisualization;
TimeseriesVisualization.defaultProps = {
  hasLegend: true
};