"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LicensePage = void 0;
exports.formatDateTimeLocal = formatDateTimeLocal;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _public = require("@kbn/kibana-react-plugin/public");
var _page_template = require("./page_template");
var _components = require("../../components");
var _global_state_context = require("../contexts/global_state_context");
var _constants = require("../../../common/constants");
var _use_monitoring_time = require("../hooks/use_monitoring_time");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/application/pages/license_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CODE_PATHS = [_constants.CODE_PATH_LICENSE];
const LicensePage = () => {
  var _services$uiSettings, _services$application, _services$data2;
  const title = _i18n.i18n.translate('xpack.monitoring.license.licenseRouteTitle', {
    defaultMessage: 'License'
  });
  const {
    setIsDisabled
  } = (0, _use_monitoring_time.useMonitoringTimeContainerContext)();
  (0, _react.useEffect)(() => {
    setIsDisabled(true);
    return () => {
      setIsDisabled(false);
    };
  }, [setIsDisabled]);
  const state = (0, _react.useContext)(_global_state_context.GlobalStateContext);
  const clusterUuid = state.cluster_uuid;
  const ccs = state.ccs;
  const [clusters, setClusters] = (0, _react.useState)([]);
  const {
    services
  } = (0, _public.useKibana)();
  const timezone = (_services$uiSettings = services.uiSettings) === null || _services$uiSettings === void 0 ? void 0 : _services$uiSettings.get('dateFormat:tz');
  const uploadLicensePath = (_services$application = services.application) === null || _services$application === void 0 ? void 0 : _services$application.getUrlForApp('management', {
    path: 'stack/license_management/upload_license'
  });
  const getPageData = (0, _react.useCallback)(async () => {
    var _services$data;
    const bounds = (_services$data = services.data) === null || _services$data === void 0 ? void 0 : _services$data.query.timefilter.timefilter.getBounds();
    let url = '../api/monitoring/v1/clusters';
    if (clusterUuid) {
      url += `/${clusterUuid}`;
    }
    try {
      var _services$http;
      const response = await ((_services$http = services.http) === null || _services$http === void 0 ? void 0 : _services$http.fetch(url, {
        method: 'POST',
        body: JSON.stringify({
          ccs,
          timeRange: {
            min: bounds.min.toISOString(),
            max: bounds.max.toISOString()
          },
          codePaths: CODE_PATHS
        })
      }));
      setClusters(formatClusters(response));
    } catch (err) {
      // TODO handle error
    }
  }, [ccs, clusterUuid, (_services$data2 = services.data) === null || _services$data2 === void 0 ? void 0 : _services$data2.query.timefilter.timefilter, services.http]);
  return /*#__PURE__*/_react.default.createElement(_page_template.PageTemplate, {
    title: title,
    pageTitle: "",
    getPageData: getPageData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }, licenseComponent(clusters, timezone, uploadLicensePath));
};
exports.LicensePage = LicensePage;
function licenseComponent(clusters, timezone, uploadLicensePath) {
  if (clusters.length) {
    const cluster = clusters[0];
    const isPrimaryCluster = cluster.isPrimary;
    const license = cluster.license;
    let expiryDate = license === null || license === void 0 ? void 0 : license.expiry_date_in_millis;
    if (expiryDate !== undefined) {
      expiryDate = formatDateTimeLocal(expiryDate, timezone);
    }
    const isExpired = Date.now() > expiryDate;
    return /*#__PURE__*/_react.default.createElement(_components.License, {
      isPrimaryCluster: isPrimaryCluster,
      status: license.status,
      type: license.type,
      isExpired: isExpired,
      expiryDate: expiryDate,
      uploadLicensePath: uploadLicensePath,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 7
      }
    });
  } else {
    return null;
  }
}

// From x-pack/plugins/monitoring/common/formatting.ts with corrected typing
// TODO open github issue to correct other usages
function formatDateTimeLocal(date, timezone) {
  return _momentTimezone.default.tz(date, timezone || _momentTimezone.default.tz.guess()).format('LL LTS');
}
function formatClusters(clusters) {
  return clusters.map(formatCluster);
}
function formatCluster(cluster) {
  if (cluster.cluster_uuid === _constants.STANDALONE_CLUSTER_CLUSTER_UUID) {
    cluster.cluster_name = 'Standalone Cluster';
  }
  return cluster;
}