"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ingestPipelineTabOnClick = exports.IngestPipelineModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _deeplinksAnalytics = require("@kbn/deeplinks-analytics");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/application/pages/elasticsearch/ingest_pipeline_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const INGEST_PIPELINE_DASHBOARD_ID = 'elasticsearch-metrics-ingest-pipelines';

/**
 * If the ingest pipeline dashboard is installed, navigate to it. Otherwise, prompt the user to install the package
 * first, then navigate. If user does not have permission to install packages, show a message.
 * @param services
 * @returns
 */
const ingestPipelineTabOnClick = async services => {
  var _services$fleet, _response$data, _response$data$items;
  const response = await ((_services$fleet = services.fleet) === null || _services$fleet === void 0 ? void 0 : _services$fleet.hooks.epm.getBulkAssets({
    assetIds: [{
      id: INGEST_PIPELINE_DASHBOARD_ID,
      type: 'dashboard'
    }]
  }));
  const dashboardFound = (response === null || response === void 0 ? void 0 : (_response$data = response.data) === null || _response$data === void 0 ? void 0 : (_response$data$items = _response$data.items) === null || _response$data$items === void 0 ? void 0 : _response$data$items.length) && response.data.items.some(item => item.id === INGEST_PIPELINE_DASHBOARD_ID);
  const navigateToDashboard = () => {
    var _services$share$url$l;
    return (_services$share$url$l = services.share.url.locators.get(_deeplinksAnalytics.DASHBOARD_APP_LOCATOR)) === null || _services$share$url$l === void 0 ? void 0 : _services$share$url$l.navigate({
      dashboardId: INGEST_PIPELINE_DASHBOARD_ID
    });
  };
  if (!dashboardFound) {
    var _services$fleet2;
    const installPackage = () => services.http.post('/api/fleet/epm/packages/elasticsearch', {
      headers: {
        'Elastic-Api-Version': '2023-10-31'
      }
    });
    const ref = services.overlays.openModal((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(IngestPipelineModal, {
      installPackage: installPackage,
      navigateToDashboard: navigateToDashboard,
      canInstallPackages: !!((_services$fleet2 = services.fleet) !== null && _services$fleet2 !== void 0 && _services$fleet2.authz.integrations.installPackages),
      closeModal: () => ref.close(),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 9
      }
    }), services));
    return await ref.onClose;
  } else {
    return navigateToDashboard();
  }
};

/**
 * Modal to prompt the user to either install the Elasticsearch integration or contact an admin.
 */
exports.ingestPipelineTabOnClick = ingestPipelineTabOnClick;
const IngestPipelineModal = ({
  canInstallPackages,
  closeModal,
  installPackage,
  navigateToDashboard
}) => {
  const [installing, setInstalling] = (0, _react.useState)(false);
  const [error, setError] = (0, _react.useState)();
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  if (!canInstallPackages) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
      "aria-labelledby": modalTitleId,
      title: _i18n.i18n.translate('xpack.monitoring.esNavigation.ingestPipelineModal.noPermissionToInstallPackage.packageRequiredTitle', {
        defaultMessage: 'Elasticsearch integration is required'
      }),
      titleProps: {
        id: modalTitleId
      },
      confirmButtonText: _i18n.i18n.translate('xpack.monitoring.esNavigation.ingestPipelineModal.noPermissionToInstallPackage.confirmButtonText', {
        defaultMessage: 'OK'
      }),
      onCancel: closeModal,
      onConfirm: closeModal,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.esNavigation.ingestPipelineModal.noPermissionToInstallPackage.descriptionText",
      defaultMessage: "Viewing Ingest pipeline metrics requires installing the Elasticsearch integration. You must ask your administrator to install it.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 11
      }
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    title: _i18n.i18n.translate('xpack.monitoring.esNavigation.ingestPipelineModal.installPromptTitle', {
      defaultMessage: 'Install Elasticsearch integration?'
    }),
    titleProps: {
      id: modalTitleId
    },
    confirmButtonText: _i18n.i18n.translate('xpack.monitoring.esNavigation.ingestPipelineModal.installButtonText', {
      defaultMessage: 'Install'
    }),
    cancelButtonText: _i18n.i18n.translate('xpack.monitoring.esNavigation.ingestPipelineModal.cancelButtonText', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonDisabled: installing,
    onCancel: closeModal,
    onConfirm: async () => {
      setInstalling(true);
      try {
        await installPackage();
        closeModal();
        navigateToDashboard();
      } catch (e) {
        var _e$body;
        setError(((_e$body = e.body) === null || _e$body === void 0 ? void 0 : _e$body.error) || e.message);
        setInstalling(false);
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 5
    }
  }, error && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.monitoring.esNavigation.ingestPipelineModal.errorCalloutText",
      defaultMessage: "Could not install the package due to an error: {error}",
      values: {
        error
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 147,
        columnNumber: 15
      }
    }),
    color: "danger",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.esNavigation.ingestPipelineModal.installPromptDescriptionText",
    defaultMessage: "Viewing Ingest pipeline metrics requires installing the Elasticsearch integration. Do you want to install it now?",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 9
    }
  })));
};
exports.IngestPipelineModal = IngestPipelineModal;