"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpaceManagement = exports.RefreshButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _mlInMemoryTable = require("@kbn/ml-in-memory-table");
var _ml = require("../../../../../contexts/ml");
var _management = require("../../../../../services/ml_api_service/management");
var _columns = require("./columns");
var _ml_saved_objects_spaces_list = require("../../../../../components/ml_saved_objects_spaces_list");
var _filters = require("./filters");
var _kibana_context = require("../../../../../contexts/kibana/kibana_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/management/jobs_list/components/jobs_list_page/space_management/space_management.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SpaceManagement = ({
  spacesApi,
  onTabChange,
  onReload
}) => {
  const {
    services: {
      application
    }
  } = (0, _kibana_context.useMlKibana)();
  const {
    getList
  } = (0, _management.useManagementApiService)();
  const [currentTabId, setCurrentTabId] = (0, _react.useState)(null);
  const [items, setItems] = (0, _react.useState)();
  const [columns, setColumns] = (0, _react.useState)([]);
  const [filters, setFilters] = (0, _react.useState)();
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const {
    isADEnabled,
    isDFAEnabled,
    isNLPEnabled
  } = (0, _ml.useEnabledFeatures)();
  const {
    onTableChange,
    pagination,
    sorting,
    setPageIndex
  } = (0, _mlInMemoryTable.useTableState)(items !== null && items !== void 0 ? items : [], 'id');
  const isMounted = (0, _react.useRef)(true);
  (0, _react.useEffect)(() => {
    return () => {
      isMounted.current = false;
    };
  }, []);
  (0, _react.useEffect)(function setInitialSelectedTab() {
    if (isADEnabled === true) {
      setCurrentTabId('anomaly-detector');
    } else if (isDFAEnabled === true) {
      setCurrentTabId('data-frame-analytics');
    } else if (isNLPEnabled === true) {
      setCurrentTabId('trained-model');
    }
  }, [isADEnabled, isDFAEnabled, isNLPEnabled]);
  const loadingTab = (0, _react.useRef)(null);
  const refresh = (0, _react.useCallback)(tabId => {
    if (tabId === null) {
      return;
    }
    loadingTab.current = tabId;
    setIsLoading(true);
    getList(tabId).then(jobList => {
      if (isMounted.current && tabId === loadingTab.current) {
        setItems(jobList);
        setIsLoading(false);
        setFilters((0, _filters.getFilters)(tabId, jobList));
      }
    }).catch(() => {
      if (isMounted.current) {
        setItems([]);
        setFilters(undefined);
        setIsLoading(false);
      }
    });
  }, [getList, loadingTab]);
  (0, _react.useEffect)(() => {
    onReload(() => () => refresh(currentTabId));
    return () => {
      onReload(null);
    };
  }, [currentTabId, refresh, onReload]);
  (0, _react.useEffect)(function refreshOnTabChange() {
    setItems(undefined);
    if (currentTabId !== null) {
      setColumns(createColumns());
      onTabChange(currentTabId);
      refresh(currentTabId);
      setPageIndex(0);
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [currentTabId]);
  const canShareIntoSpace = (0, _react.useMemo)(() => {
    var _application$capabili, _application$capabili2;
    return !(application !== null && application !== void 0 && (_application$capabili = application.capabilities) !== null && _application$capabili !== void 0 && (_application$capabili2 = _application$capabili.savedObjectsManagement) !== null && _application$capabili2 !== void 0 && _application$capabili2.shareIntoSpace);
  }, [application]);
  const createColumns = (0, _react.useCallback)(() => {
    if (currentTabId === null) {
      return [];
    }
    return [...(0, _columns.getColumns)(currentTabId), ...(spacesApi !== undefined ? [{
      name: _i18n.i18n.translate('xpack.ml.management.spaceManagementTableColumn.spaces', {
        defaultMessage: 'spaces'
      }),
      'data-test-subj': 'mlSpaceManagementTableColumnSpaces',
      sortable: true,
      truncateText: true,
      align: 'right',
      width: '10%',
      render: item => {
        return /*#__PURE__*/_react.default.createElement(_ml_saved_objects_spaces_list.MLSavedObjectsSpacesList, {
          disabled: canShareIntoSpace,
          spacesApi: spacesApi,
          spaceIds: item.spaces,
          mlSavedObjectType: currentTabId,
          id: item.id,
          refresh: refresh.bind(null, currentTabId),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 152,
            columnNumber: 19
          }
        });
      }
    }] : [])];
  }, [currentTabId, spacesApi, refresh, canShareIntoSpace]);
  const getTable = (0, _react.useCallback)(() => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
      size: "xs",
      color: "accent",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 22
      }
    }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 9
      }
    }), items === undefined ? null : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: 'flexEnd',
      gutterSize: 'none',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(RefreshButton, {
      onRefreshClick: refresh.bind(null, currentTabId),
      isRefreshing: isLoading,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 178,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
      "data-test-subj": `mlSpacesManagementTable-${currentTabId} ${isLoading ? 'loading' : 'loaded'}`,
      items: items,
      columns: columns,
      search: {
        box: {
          incremental: true
        },
        filters
      },
      onTableChange: onTableChange,
      pagination: pagination,
      sorting: sorting,
      rowProps: item => ({
        'data-test-subj': `mlSpacesManagementTable-${currentTabId} row-${item.id}`
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 184,
        columnNumber: 13
      }
    })));
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [items, columns, isLoading, filters, currentTabId, refresh, onTableChange]);
  const tabs = (0, _react.useMemo)(() => {
    const tempTabs = [];
    if (isADEnabled === true) {
      tempTabs.push({
        'data-test-subj': 'mlStackManagementAnomalyDetectionTab',
        id: 'anomaly-detector',
        name: _i18n.i18n.translate('xpack.ml.management.list.anomalyDetectionTab', {
          defaultMessage: 'Anomaly detection'
        }),
        content: getTable()
      });
    }
    if (isDFAEnabled === true) {
      tempTabs.push({
        'data-test-subj': 'mlStackManagementAnalyticsTab',
        id: 'data-frame-analytics',
        name: _i18n.i18n.translate('xpack.ml.management.list.analyticsTab', {
          defaultMessage: 'Analytics'
        }),
        content: getTable()
      });
    }
    if (isNLPEnabled === true || isDFAEnabled === true) {
      tempTabs.push({
        'data-test-subj': 'mlStackManagementTrainedModelsTab',
        id: 'trained-model',
        name: _i18n.i18n.translate('xpack.ml.management.list.trainedModelsTab', {
          defaultMessage: 'Trained models'
        }),
        content: getTable()
      });
    }
    return tempTabs;
  }, [getTable, isADEnabled, isDFAEnabled, isNLPEnabled]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    "data-test-subj": "mlSpacesManagementTable",
    onTabClick: ({
      id
    }) => {
      setCurrentTabId(id);
    },
    size: "s",
    tabs: tabs,
    initialSelectedTab: tabs[0],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 5
    }
  });
};
exports.SpaceManagement = SpaceManagement;
const RefreshButton = ({
  onRefreshClick,
  isRefreshing
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
  "data-test-subj": `mlDatePickerRefreshPageButton${isRefreshing ? ' loading' : ' loaded'}`,
  onClick: onRefreshClick,
  isLoading: isRefreshing,
  iconType: 'refresh',
  iconSide: 'left',
  iconSize: 'm',
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 263,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.ml.management.list.refreshButtonLabel",
  defaultMessage: "Refresh",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 271,
    columnNumber: 5
  }
}));
exports.RefreshButton = RefreshButton;