"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedDetectorModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _mlFieldStatsFlyout = require("@kbn/ml-field-stats-flyout");
var _job_creator_context = require("../../../job_creator_context");
var _general = require("../../../../../common/job_creator/util/general");
var _fields_utils = require("../../../../../../../../../common/util/fields_utils");
var _modal_wrapper = require("./modal_wrapper");
var _string_utils = require("../../../../../../../util/string_utils");
var _default_configs = require("../../../../../common/job_creator/util/default_configs");
var _descriptions = require("./descriptions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/pick_fields_step/components/advanced_detector_modal/advanced_detector_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const emptyOption = {
  label: ''
};
const excludeFrequentOptions = [{
  label: 'all'
}, {
  label: 'none'
}, {
  label: 'by'
}, {
  label: 'over'
}];
const AdvancedDetectorModal = ({
  payload,
  fields,
  aggs,
  detectorChangeHandler,
  closeModal
}) => {
  const {
    jobCreator: jc
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const jobCreator = jc;
  const [detector, setDetector] = (0, _react.useState)(payload.detector);
  const [aggOption, setAggOption] = (0, _react.useState)(createAggOption(detector.agg));
  const [fieldOption, setFieldOption] = (0, _react.useState)(createFieldOption(detector.field));
  const [byFieldOption, setByFieldOption] = (0, _react.useState)(createFieldOption(detector.byField));
  const [overFieldOption, setOverFieldOption] = (0, _react.useState)(createFieldOption(detector.overField));
  const [partitionFieldOption, setPartitionFieldOption] = (0, _react.useState)(createFieldOption(detector.partitionField));
  const [excludeFrequentOption, setExcludeFrequentOption] = (0, _react.useState)(createExcludeFrequentOption(detector.excludeFrequent));
  const [descriptionOption, setDescriptionOption] = (0, _react.useState)(detector.description || '');
  const [splitFieldsEnabled, setSplitFieldsEnabled] = (0, _react.useState)(true);
  const [excludeFrequentEnabled, setExcludeFrequentEnabled] = (0, _react.useState)(true);
  const [fieldOptionEnabled, setFieldOptionEnabled] = (0, _react.useState)(true);
  const {
    descriptionPlaceholder,
    setDescriptionPlaceholder
  } = useDetectorPlaceholder(detector);
  const [selectedFieldNames, setSelectedFieldNames] = (0, _react.useState)([]);
  const aggDescriptionTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'aggDescriptionTitleId'
  });
  const fieldDescriptionTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'fieldDescriptionTitleId'
  });
  const byFieldDescriptionTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'byFieldDescriptionTitleId'
  });
  const overFieldDescriptionTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'overFieldDescriptionTitleId'
  });
  const partitionFieldDescriptionTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'partitionFieldDescriptionTitleId'
  });
  const excludeFrequentDescriptionTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'excludeFrequentDescriptionTitleId'
  });
  const descriptionDescriptionTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'descriptionDescriptionTitleId'
  });
  const usingScriptFields = jobCreator.additionalFields.length > 0;
  // list of aggregation combobox options.

  const {
    renderOption,
    optionCss
  } = (0, _mlFieldStatsFlyout.useFieldStatsTrigger)();
  const aggOptions = aggs.filter(agg => filterAggs(agg, usingScriptFields)).map(createAggOption).map(o => ({
    ...o,
    css: optionCss
  }));

  // fields available for the selected agg
  const {
    currentFieldOptions,
    setCurrentFieldOptions
  } = useCurrentFieldOptions(detector.agg, (0, _fields_utils.filterCategoryFields)(jobCreator.additionalFields, false), selectedFieldNames);
  const allFieldOptions = [...(0, _general.createFieldOptions)(fields, jobCreator.additionalFields)].sort(comboBoxOptionsSort).map(o => ({
    ...o,
    css: optionCss
  }));
  const splitFieldOptions = [...allFieldOptions, ...(0, _general.createMlcategoryFieldOption)(jobCreator.categorizationFieldName)].sort(comboBoxOptionsSort).filter(({
    label
  }) => selectedFieldNames.includes(label) === false).map(o => ({
    ...o,
    css: optionCss
  }));
  const eventRateField = fields.find(f => f.id === _mlAnomalyUtils.EVENT_RATE_FIELD_ID);
  const onOptionChange = func => selectedOptions => {
    func(selectedOptions[0] || emptyOption);
  };
  function getAgg(title) {
    return aggs.find(a => a.id === title) || null;
  }
  function getField(title) {
    if (title === _mlAnomalyUtils.mlCategory.id) {
      return _mlAnomalyUtils.mlCategory;
    }
    return fields.find(f => f.id === title) || jobCreator.additionalFields.find(f => f.id === title) || null;
  }
  (0, _react.useEffect)(() => {
    const agg = getAgg(aggOption.label);
    let field = getField(fieldOption.label);
    const byField = getField(byFieldOption.label);
    const overField = getField(overFieldOption.label);
    const partitionField = getField(partitionFieldOption.label);
    if (agg !== null) {
      setCurrentFieldOptions(agg);
      if (isFieldlessAgg(agg) && eventRateField !== undefined) {
        setSplitFieldsEnabled(true);
        setFieldOption(emptyOption);
        setFieldOptionEnabled(false);
        field = eventRateField;
      } else {
        setSplitFieldsEnabled(field !== null);
        setFieldOptionEnabled(true);
      }
      // only enable exclude frequent if there is a by or over selected
      setExcludeFrequentEnabled(byField !== null || overField !== null);
    } else {
      setSplitFieldsEnabled(false);
      setFieldOptionEnabled(false);
    }
    setSelectedFieldNames([...(field ? [field.name] : []), ...(byField ? [byField.name] : []), ...(overField ? [overField.name] : []), ...(partitionField ? [partitionField.name] : [])]);
    const dtr = {
      agg,
      field,
      byField,
      overField,
      partitionField,
      excludeFrequent: excludeFrequentOption.label !== '' ? excludeFrequentOption.label : null,
      description: descriptionOption !== '' ? descriptionOption : null,
      customRules: null,
      useNull: null
    };
    setDetector(dtr);
    setDescriptionPlaceholder(dtr);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [aggOption, fieldOption, byFieldOption, overFieldOption, partitionFieldOption, excludeFrequentOption, descriptionOption]);
  (0, _react.useEffect)(() => {
    const agg = getAgg(aggOption.label);
    setSplitFieldsEnabled(aggOption.label !== '');
    if (agg !== null) {
      setFieldOptionEnabled(isFieldlessAgg(agg) === false);
      const byField = getField(byFieldOption.label);
      const overField = getField(overFieldOption.label);
      setExcludeFrequentEnabled(byField !== null || overField !== null);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  (0, _react.useEffect)(() => {
    // wipe the exclude frequent choice if the select has been disabled
    if (excludeFrequentEnabled === false) {
      setExcludeFrequentOption(emptyOption);
    }
  }, [excludeFrequentEnabled]);
  function onCreateClick() {
    detectorChangeHandler(detector, payload.index);
  }
  function saveEnabled() {
    return splitFieldsEnabled && (fieldOptionEnabled === false || fieldOptionEnabled === true && fieldOption.label !== '');
  }
  return /*#__PURE__*/_react.default.createElement(_modal_wrapper.ModalWrapper, {
    onCreateClick: onCreateClick,
    closeModal: closeModal,
    saveEnabled: saveEnabled(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 269,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 270,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "mlAdvancedFunctionSelect",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 271,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_descriptions.AggDescription, {
    titleId: aggDescriptionTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    singleSelection: {
      asPlainText: true
    },
    options: aggOptions,
    selectedOptions: createSelectedOptions(aggOption),
    onChange: onOptionChange(setAggOption),
    isClearable: true,
    renderOption: renderOption,
    "aria-labelledby": aggDescriptionTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "mlAdvancedFieldSelect",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 284,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_descriptions.FieldDescription, {
    titleId: fieldDescriptionTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 285,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_mlFieldStatsFlyout.OptionListWithFieldStats, {
    singleSelection: {
      asPlainText: true
    },
    options: currentFieldOptions,
    selectedOptions: createSelectedOptions(fieldOption),
    onChange: onOptionChange(setFieldOption),
    isClearable: true,
    isDisabled: fieldOptionEnabled === false,
    titleId: fieldDescriptionTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 286,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 298,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 299,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "mlAdvancedByFieldSelect",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 300,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_descriptions.ByFieldDescription, {
    titleId: byFieldDescriptionTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 301,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_mlFieldStatsFlyout.OptionListWithFieldStats, {
    singleSelection: {
      asPlainText: true
    },
    options: splitFieldOptions,
    selectedOptions: createSelectedOptions(byFieldOption),
    onChange: onOptionChange(setByFieldOption),
    isClearable: true,
    isDisabled: splitFieldsEnabled === false,
    titleId: byFieldDescriptionTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 302,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "mlAdvancedOverFieldSelect",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 313,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_descriptions.OverFieldDescription, {
    titleId: overFieldDescriptionTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 314,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_mlFieldStatsFlyout.OptionListWithFieldStats, {
    singleSelection: {
      asPlainText: true
    },
    options: splitFieldOptions,
    selectedOptions: createSelectedOptions(overFieldOption),
    onChange: onOptionChange(setOverFieldOption),
    isClearable: true,
    isDisabled: splitFieldsEnabled === false,
    titleId: overFieldDescriptionTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 315,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "mlAdvancedPartitionFieldSelect",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 326,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_descriptions.PartitionFieldDescription, {
    titleId: partitionFieldDescriptionTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 327,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_mlFieldStatsFlyout.OptionListWithFieldStats, {
    singleSelection: {
      asPlainText: true
    },
    options: splitFieldOptions,
    selectedOptions: createSelectedOptions(partitionFieldOption),
    onChange: onOptionChange(setPartitionFieldOption),
    isClearable: true,
    isDisabled: splitFieldsEnabled === false,
    titleId: partitionFieldDescriptionTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 328,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "mlAdvancedExcludeFrequentSelect",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 339,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_descriptions.ExcludeFrequentDescription, {
    titleId: excludeFrequentDescriptionTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 340,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_mlFieldStatsFlyout.OptionListWithFieldStats, {
    singleSelection: {
      asPlainText: true
    },
    options: excludeFrequentOptions,
    selectedOptions: createSelectedOptions(excludeFrequentOption),
    onChange: onOptionChange(setExcludeFrequentOption),
    isClearable: true,
    isDisabled: splitFieldsEnabled === false || excludeFrequentEnabled === false,
    titleId: excludeFrequentDescriptionTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 341,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 353,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 354,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 355,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_descriptions.DescriptionDescription, {
    titleId: descriptionDescriptionTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 356,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
    rows: 2,
    fullWidth: true,
    placeholder: descriptionPlaceholder,
    value: descriptionOption,
    onChange: e => setDescriptionOption(e.target.value),
    "data-test-subj": "mlAdvancedDetectorDescriptionInput",
    "aria-labelledby": descriptionDescriptionTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 357,
      columnNumber: 15
    }
  }))))));
};
exports.AdvancedDetectorModal = AdvancedDetectorModal;
function createAggOption(agg) {
  if (agg === null) {
    return emptyOption;
  }
  return {
    label: agg.id
  };
}

// get list of aggregations, filtering out any aggs with no fields,
// unless script fields are being used, in which case list all fields, as it's not possible
// to determine the type of a script field and so all aggs should be available.
function filterAggs(agg, usingScriptFields) {
  return agg.fields !== undefined && (usingScriptFields || agg.fields.length);
}
function createFieldOption(field) {
  if (field === null) {
    return emptyOption;
  }
  return {
    label: field.name
  };
}
function createExcludeFrequentOption(excludeFrequent) {
  if (excludeFrequent === null) {
    return emptyOption;
  }
  return {
    label: excludeFrequent
  };
}
function isFieldlessAgg(agg) {
  // fieldless aggs have been given one event rate field for UI reasons.
  // therefore if an agg's field list only contains event rate, it must be
  // a fieldless agg.
  return agg.fields && agg.fields.length === 1 && agg.fields[0].id === _mlAnomalyUtils.EVENT_RATE_FIELD_ID;
}
function useDetectorPlaceholder(detector) {
  const [descriptionPlaceholder, setDescriptionPlaceholderString] = (0, _react.useState)(createDefaultDescription(detector));
  function setDescriptionPlaceholder(dtr) {
    setDescriptionPlaceholderString(createDefaultDescription(dtr));
  }
  return {
    descriptionPlaceholder,
    setDescriptionPlaceholder
  };
}

// creates list of combobox options based on an aggregation's field list
function createFieldOptionsFromAgg(agg, additionalFields) {
  return (0, _general.createFieldOptions)(agg !== null && agg.fields !== undefined ? agg.fields : [], additionalFields);
}

// custom hook for storing combobox options based on an aggregation field list
function useCurrentFieldOptions(aggregation, additionalFields, selectedFieldNames) {
  const [currentFieldOptions, setCurrentFieldOptions] = (0, _react.useState)(createFieldOptionsFromAgg(aggregation, additionalFields));
  return {
    currentFieldOptions: currentFieldOptions.filter(({
      label
    }) => selectedFieldNames.includes(label) === false),
    setCurrentFieldOptions: agg => setCurrentFieldOptions(createFieldOptionsFromAgg(agg, additionalFields))
  };
}
function createDefaultDescription(dtr) {
  if (dtr.agg === null || dtr.field === null) {
    return '';
  }
  const basicDetector = (0, _default_configs.createBasicDetector)(dtr.agg, dtr.field);
  basicDetector.by_field_name = dtr.byField ? dtr.byField.id : undefined;
  basicDetector.over_field_name = dtr.overField ? dtr.overField.id : undefined;
  basicDetector.partition_field_name = dtr.partitionField ? dtr.partitionField.id : undefined;
  basicDetector.exclude_frequent = dtr.excludeFrequent ? dtr.excludeFrequent : undefined;
  return (0, _string_utils.detectorToString)(basicDetector);
}
function createSelectedOptions(selectedOption) {
  return selectedOption === undefined || selectedOption.label === '' ? [] : [selectedOption];
}
function comboBoxOptionsSort(a, b) {
  return a.label.localeCompare(b.label);
}