"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobDetailsFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _kibana = require("../../../contexts/kibana");
var _job_details = require("../../jobs_list/components/job_details");
var _utils = require("../../jobs_list/components/utils");
var _toast_notification_service = require("../../../services/toast_notification_service");
var _locator = require("../../../../../common/constants/locator");
var _job_details_flyout_context = require("./job_details_flyout_context");
var _use_create_url = require("../../../contexts/kibana/use_create_url");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/components/job_details_flyout/job_details_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const doNothing = () => {};
const JobDetailsFlyout = () => {
  const {
    isDetailFlyoutOpen,
    activeJobId: jobId,
    setActiveJobId,
    closeActiveFlyout
  } = (0, _job_details_flyout_context.useJobInfoFlyouts)();
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'jobDetailsFlyout'
  });
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [jobDetails, setJobDetails] = (0, _react.useState)(null);
  const mlApi = (0, _kibana.useMlApi)();
  const {
    displayErrorToast
  } = (0, _toast_notification_service.useToastNotificationService)();
  const isMounted = (0, _useMountedState.default)();
  (0, _react.useEffect)(() => {
    const fetchJobDetails = async () => {
      if (!isMounted()) return;
      if (jobId) {
        setIsLoading(true);
        try {
          const job = await (0, _utils.loadFullJob)(mlApi, jobId);
          if (job) {
            setJobDetails(job);
          }
        } catch (error) {
          displayErrorToast(error, _i18n.i18n.translate('xpack.ml.jobDetailsFlyout.errorFetchingJobDetails', {
            defaultMessage: 'Error fetching job details'
          }));
        } finally {
          setIsLoading(false);
        }
      }
    };
    fetchJobDetails();
  }, [jobId, mlApi, displayErrorToast, isMounted]);
  const pageState = (0, _react.useMemo)(() => ({
    jobId
  }), [jobId]);
  const openJobsList = (0, _use_create_url.useCreateAndNavigateToManagementMlLink)(_locator.ML_PAGES.ANOMALY_DETECTION_JOBS_MANAGE, 'anomaly_detection', pageState);
  if (!jobId) {
    return null;
  }
  return isDetailFlyoutOpen ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    "data-test-subj": "jobDetailsFlyout",
    type: "overlay",
    size: "m",
    ownFocus: false,
    onClose: () => {
      closeActiveFlyout();
      setActiveJobId(null);
    },
    "aria-labelledby": flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    "data-test-subj": `jobDetailsFlyout-${jobId}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 15
    }
  }, jobId))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: openJobsList,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.jobDetailsFlyout.manageJobButton",
    defaultMessage: "Manage job",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 15
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 7
    }
  }, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 13
    }
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, jobDetails ? /*#__PURE__*/_react.default.createElement(_job_details.JobDetails, {
    mode: "flyout",
    jobId: jobId,
    job: jobDetails
    // No need to add or remove from the job list
    ,
    addYourself: doNothing,
    removeYourself: doNothing,
    refreshJobList: doNothing,
    showClearButton: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 15
    }
  }) : null))) : null;
};
exports.JobDetailsFlyout = JobDetailsFlyout;