"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SwimLanePagination = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _calculate_row_options = require("./calculate_row_options");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/explorer/swimlane_pagination.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SwimLanePagination = ({
  cardinality,
  fromPage,
  perPage,
  onPaginationChange
}) => {
  const componentFromPage = fromPage - 1;
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onButtonClick = () => setIsPopoverOpen(() => !isPopoverOpen);
  const closePopover = () => setIsPopoverOpen(false);
  const goToPage = (0, _react.useCallback)(pageNumber => {
    onPaginationChange({
      fromPage: pageNumber + 1
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const setPerPage = (0, _react.useCallback)(perPageUpdate => {
    onPaginationChange({
      perPage: perPageUpdate
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const pageCount = Math.ceil(cardinality / perPage);
  const rowOptions = [5, 10, 20, 50, 100];
  const items = (0, _calculate_row_options.calculateRowOptions)(rowOptions, cardinality);
  const menuItems = items.map(v => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: `${v}_rows`,
    icon: v === perPage ? 'check' : 'empty',
    onClick: () => {
      closePopover();
      setPerPage(v);
    },
    "data-test-subj": `${v} rows`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.explorer.swimLaneSelectRowsPerPage",
    defaultMessage: "{rowsCount} rows",
    values: {
      rowsCount: v
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  })));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      color: "text",
      iconType: "arrowDown",
      iconSide: "right",
      onClick: onButtonClick,
      "data-test-subj": "mlSwimLanePageSizeControl",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": perPage,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.explorer.swimLaneRowsPerPage",
      defaultMessage: "Rows per page: {rowsCount}",
      values: {
        rowsCount: perPage
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 17
      }
    }))),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: menuItems,
    "data-test-subj": "mlSwimLanePageSizePanel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPagination, {
    "aria-label": _i18n.i18n.translate('xpack.ml.explorer.swimLanePagination', {
      defaultMessage: 'Anomaly swim lane pagination'
    }),
    pageCount: pageCount,
    activePage: componentFromPage,
    onPageClick: goToPage,
    "data-test-subj": "mlSwimLanePagination",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 9
    }
  })));
};
exports.SwimLanePagination = SwimLanePagination;