"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExplorerChartsContainerUI = exports.ExplorerChartsContainer = void 0;
exports.getEntitiesQuery = getEntitiesQuery;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _chart_utils = require("../../util/chart_utils");
var _explorer_chart_distribution = require("./explorer_chart_distribution");
var _explorer_chart_single_metric = require("./explorer_chart_single_metric");
var _explorer_chart_label = require("./components/explorer_chart_label");
var _explorer_constants = require("../explorer_constants");
var _mlQueryUtils = require("@kbn/ml-query-utils");
var _i18n = require("@kbn/i18n");
var _chartsTheme = require("@kbn/charts-theme");
var _i18nReact = require("@kbn/i18n-react");
var _chart_tooltip = require("../../components/chart_tooltip");
var _public = require("@kbn/kibana-react-plugin/public");
var _kibana = require("../../contexts/kibana");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _util = require("../../../maps/util");
var _common = require("@kbn/maps-plugin/common");
var _public2 = require("@kbn/maps-plugin/public");
var _explorer_charts_error_callouts = require("./explorer_charts_error_callouts");
var _recently_accessed = require("../../util/recently_accessed");
var _explorer_chart_embedded_map = require("./explorer_chart_embedded_map");
var _public3 = require("@kbn/charts-plugin/public");
var _charts = require("@elastic/charts");
var _string_utils = require("../../util/string_utils");
var _explorer_chart_styles = require("./explorer_chart_styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/explorer/explorer_charts/explorer_charts_container.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const textTooManyBuckets = _i18n.i18n.translate('xpack.ml.explorer.charts.tooManyBucketsDescription', {
  defaultMessage: 'This selection contains too many buckets to be displayed. You should shorten the time range of the view or narrow the selection in the timeline.'
});
const textViewButton = _i18n.i18n.translate('xpack.ml.explorer.charts.openInSingleMetricViewerButtonLabel', {
  defaultMessage: 'Open in Single Metric Viewer'
});
const mapsPluginMessage = _i18n.i18n.translate('xpack.ml.explorer.charts.mapsPluginMissingMessage', {
  defaultMessage: 'maps or embeddable start plugin not found'
});
const openInMapsPluginMessage = _i18n.i18n.translate('xpack.ml.explorer.charts.openInMapsPluginMessage', {
  defaultMessage: 'Open in Maps'
});
function getEntitiesQuery(series) {
  var _series$entityFields;
  const queryString = (_series$entityFields = series.entityFields) === null || _series$entityFields === void 0 ? void 0 : _series$entityFields.map(({
    fieldName,
    fieldValue
  }) => (0, _string_utils.escapeKueryForFieldValuePair)(fieldName, fieldValue)).join(' or ');
  const query = {
    language: _mlQueryUtils.SEARCH_QUERY_LANGUAGE.KUERY,
    query: queryString
  };
  return {
    query,
    queryString
  };
}

// create a somewhat unique ID
// from charts metadata for React's key attribute
function getChartId(series, randomId) {
  const {
    jobId,
    detectorLabel
  } = series;
  const id = `${jobId}${detectorLabel}`.replace(/[^a-zA-Z]+/g, '') + randomId;
  return id;
}

// Wrapper for a single explorer chart
function ExplorerChartContainer({
  id,
  isEmbeddable,
  series,
  severity,
  tooManyBuckets,
  wrapLabel,
  mlLocator,
  tableData,
  timeBuckets,
  timefilter,
  timeRange,
  onSelectEntity,
  tooManyBucketsCalloutMsg,
  showSelectedInterval,
  chartsService,
  showFilterIcons
}) {
  const [explorerSeriesLink, setExplorerSeriesLink] = (0, _react.useState)('');
  const [mapsLink, setMapsLink] = (0, _react.useState)('');
  const {
    services: {
      chrome: {
        recentlyAccessed
      },
      share,
      application: {
        navigateToApp
      }
    }
  } = (0, _kibana.useMlKibana)();
  const chartBaseTheme = (0, _chartsTheme.useElasticChartsTheme)();
  const getMapsLink = (0, _react.useCallback)(async () => {
    const {
      queryString,
      query
    } = getEntitiesQuery(series);
    const initialLayers = (0, _util.getInitialAnomaliesLayers)(series.jobId);
    const locator = share.url.locators.get(_public2.MAPS_APP_LOCATOR);
    const location = await locator.getLocation({
      initialLayers: initialLayers,
      timeRange: timeRange !== null && timeRange !== void 0 ? timeRange : timefilter === null || timefilter === void 0 ? void 0 : timefilter.getTime(),
      ...(queryString !== undefined ? {
        query
      } : {})
    });
    return location;
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [series === null || series === void 0 ? void 0 : series.jobId, timeRange]);
  (0, _react.useEffect)(() => {
    let isCancelled = false;
    const generateLink = async () => {
      // Prioritize timeRange from embeddable panel or case
      // Else use the time range from data plugins's timefilters service
      let mergedTimeRange = timeRange;
      const bounds = timefilter === null || timefilter === void 0 ? void 0 : timefilter.getActiveBounds();
      if (!timeRange && bounds) {
        mergedTimeRange = {
          from: bounds.min.toISOString(),
          to: bounds.max.toISOString()
        };
      }
      if (!isCancelled && series.functionDescription !== _mlAnomalyUtils.ML_JOB_AGGREGATION.LAT_LONG) {
        try {
          const singleMetricViewerLink = await (0, _chart_utils.getExploreSeriesLink)(mlLocator, series, mergedTimeRange);
          setExplorerSeriesLink(singleMetricViewerLink);
        } catch (error) {
          setExplorerSeriesLink('');
        }
      }
    };
    generateLink();
    return () => {
      isCancelled = true;
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [mlLocator, series, timeRange]);
  (0, _react.useEffect)(function getMapsPluginLink() {
    let isCancelled = false;
    if (series && (0, _chart_utils.getChartType)(series) === _explorer_constants.CHART_TYPE.GEO_MAP) {
      const generateLink = async () => {
        try {
          const mapsLink = await getMapsLink();
          if (!isCancelled) {
            setMapsLink(mapsLink === null || mapsLink === void 0 ? void 0 : mapsLink.path);
          }
        } catch (error) {
          console.error(error);
          setMapsLink('');
        }
      };
      generateLink().catch(console.error);
    }
    return () => {
      isCancelled = true;
    };
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [series]);
  const chartRef = (0, _react.useRef)(null);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const chartTheme = chartsService.theme.useChartsBaseTheme();
  const handleCursorUpdate = (0, _public3.useActiveCursor)(chartsService.activeCursor, chartRef, {
    isDateHistogram: true
  });
  const addToRecentlyAccessed = (0, _react.useCallback)(() => {
    if (recentlyAccessed) {
      (0, _recently_accessed.addItemToRecentlyAccessed)('timeseriesexplorer', series.jobId, explorerSeriesLink, recentlyAccessed);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [explorerSeriesLink, recentlyAccessed]);
  const {
    detectorLabel,
    entityFields
  } = series;
  const chartType = (0, _chart_utils.getChartType)(series);
  let DetectorLabel = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 23
    }
  }, detectorLabel);
  if (chartType === _explorer_constants.CHART_TYPE.EVENT_DISTRIBUTION) {
    const byField = series.entityFields.find(d => d.fieldType === 'by');
    if (typeof byField !== 'undefined') {
      DetectorLabel = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 221,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.explorer.charts.detectorLabel",
        defaultMessage: "{detectorLabel}{br}y-axis event distribution split by \"{fieldName}\"",
        values: {
          detectorLabel,
          br: /*#__PURE__*/_react.default.createElement("br", {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 227,
              columnNumber: 19
            }
          }),
          fieldName: byField.fieldName
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 222,
          columnNumber: 11
        }
      }));
      wrapLabel = true;
    }
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 0,
      height: 0
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    ref: chartRef,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    baseTheme: chartBaseTheme,
    noResults: /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 245,
        columnNumber: 24
      }
    }),
    width: 0,
    height: 0,
    locale: _i18n.i18n.getLocale(),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: 'count',
    xAccessor: "x",
    yAccessors: ['y'],
    data: [],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_explorer_chart_label.ExplorerChartLabel, {
    isEmbeddable: isEmbeddable,
    detectorLabel: DetectorLabel,
    entityFields: entityFields,
    infoTooltip: {
      ...series.infoTooltip,
      chartType
    },
    wrapLabel: wrapLabel,
    onSelectEntity: onSelectEntity,
    showFilterIcons: showFilterIcons,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
              padding: ${euiTheme.size.xs};
            `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 11
    }
  }, tooManyBuckets && /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: tooManyBucketsCalloutMsg !== null && tooManyBucketsCalloutMsg !== void 0 ? tooManyBucketsCalloutMsg : textTooManyBuckets,
    position: "top",
    size: "s",
    type: "warning",
    color: "warning",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 15
    }
  }), explorerSeriesLink && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: textViewButton,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 282,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconSide: "right",
    iconType: "singleMetricViewer",
    size: "xs",
    href: explorerSeriesLink,
    onClick: addToRecentlyAccessed,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 286,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.explorer.charts.viewLabel",
    defaultMessage: "View",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 19
    }
  }))), chartType === _explorer_constants.CHART_TYPE.GEO_MAP && mapsLink ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: openInMapsPluginMessage,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 298,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconSide: "right",
    iconType: "logoMaps",
    size: "xs",
    onClick: async () => {
      await navigateToApp(_common.APP_ID, {
        path: mapsLink
      });
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 299,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.explorer.charts.viewInMapsLabel",
    defaultMessage: "View",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 19
    }
  }))) : null))), (() => {
    if (chartType === _explorer_constants.CHART_TYPE.GEO_MAP) {
      return /*#__PURE__*/_react.default.createElement(_chart_tooltip.MlTooltipComponent, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 320,
          columnNumber: 13
        }
      }, tooltipService => /*#__PURE__*/_react.default.createElement(_explorer_chart_embedded_map.EmbeddedMapComponentWrapper, {
        seriesConfig: series,
        tooltipService: tooltipService,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 322,
          columnNumber: 17
        }
      }));
    }
    if (chartType === _explorer_constants.CHART_TYPE.EVENT_DISTRIBUTION || chartType === _explorer_constants.CHART_TYPE.POPULATION_DISTRIBUTION) {
      return /*#__PURE__*/_react.default.createElement(_chart_tooltip.MlTooltipComponent, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 336,
          columnNumber: 13
        }
      }, tooltipService => /*#__PURE__*/_react.default.createElement(_explorer_chart_distribution.ExplorerChartDistribution, {
        id: id,
        tableData: tableData,
        timeBuckets: timeBuckets,
        tooManyBuckets: tooManyBuckets,
        seriesConfig: series,
        severity: severity,
        tooltipService: tooltipService,
        showSelectedInterval: showSelectedInterval,
        onPointerUpdate: handleCursorUpdate,
        chartTheme: chartTheme,
        cursor$: chartsService.activeCursor.activeCursor$,
        euiTheme: euiTheme,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 338,
          columnNumber: 17
        }
      }));
    }
    if (chartType === _explorer_constants.CHART_TYPE.SINGLE_METRIC) {
      return /*#__PURE__*/_react.default.createElement(_chart_tooltip.MlTooltipComponent, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 358,
          columnNumber: 13
        }
      }, tooltipService => /*#__PURE__*/_react.default.createElement(_explorer_chart_single_metric.ExplorerChartSingleMetric, {
        id: id,
        tableData: tableData,
        timeBuckets: timeBuckets,
        tooManyBuckets: tooManyBuckets,
        seriesConfig: series,
        severity: severity,
        tooltipService: tooltipService,
        showSelectedInterval: showSelectedInterval,
        onPointerUpdate: handleCursorUpdate,
        chartTheme: chartTheme,
        cursor$: chartsService.activeCursor.activeCursor$,
        euiTheme: euiTheme,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 360,
          columnNumber: 17
        }
      }));
    }
  })());
}

// Flex layout wrapper for all explorer charts
const ExplorerChartsContainerUI = ({
  id: uuid,
  isEmbeddable,
  chartsPerRow,
  seriesToPlot,
  severity,
  tooManyBuckets,
  kibana,
  errorMessages,
  mlLocator,
  tableData,
  timeBuckets,
  timefilter,
  timeRange,
  onSelectEntity,
  tooManyBucketsCalloutMsg,
  showSelectedInterval,
  chartsService,
  showFilterIcons = true
}) => {
  const cssMlExplorerChartContainer = (0, _explorer_chart_styles.useCssMlExplorerChartContainer)();
  const {
    services: {
      embeddable: embeddablePlugin,
      maps: mapsPlugin
    }
  } = kibana;
  let seriesToPlotFiltered;
  if (!embeddablePlugin || !mapsPlugin) {
    seriesToPlotFiltered = [];
    // Show missing plugin callout
    seriesToPlot.forEach(series => {
      if (series.functionDescription === 'lat_long') {
        if (errorMessages[mapsPluginMessage] === undefined) {
          errorMessages[mapsPluginMessage] = new Set([series.jobId]);
        } else {
          errorMessages[mapsPluginMessage].add(series.jobId);
        }
      } else {
        seriesToPlotFiltered.push(series);
      }
    });
  }
  const seriesToUse = seriesToPlotFiltered !== undefined ? seriesToPlotFiltered : seriesToPlot;

  // <EuiFlexGrid> doesn't allow a setting of `columns={1}` when chartsPerRow would be 1.
  // If that's the case we trick it doing that with the following settings:
  const chartsWidth = chartsPerRow === 1 ? 'calc(100% - 20px)' : 'auto';
  const chartsColumns = chartsPerRow === 1 ? 0 : chartsPerRow;
  const wrapLabel = seriesToUse.some(series => (0, _chart_utils.isLabelLengthAboveThreshold)(series));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_explorer_charts_error_callouts.ExplorerChartsErrorCallOuts, {
    errorMessagesByType: errorMessages,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 438,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: chartsColumns,
    gutterSize: "m",
    "data-test-subj": "mlExplorerChartsContainer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 439,
      columnNumber: 7
    }
  }, seriesToUse.length > 0 && seriesToUse.map((series, idx) => {
    const chartId = getChartId(series, '-' + (uuid !== null && uuid !== void 0 ? uuid : '') + idx);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: chartId,
      "data-test-subj": "mlExplorerChartContainerItem",
      css: cssMlExplorerChartContainer,
      style: {
        minWidth: chartsWidth
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 448,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(ExplorerChartContainer, {
      key: chartId,
      id: chartId,
      isEmbeddable: isEmbeddable,
      series: series,
      severity: severity,
      tooManyBuckets: tooManyBuckets,
      wrapLabel: wrapLabel,
      mlLocator: mlLocator,
      tableData: tableData,
      timeBuckets: timeBuckets,
      timefilter: timefilter,
      timeRange: timeRange,
      onSelectEntity: onSelectEntity,
      tooManyBucketsCalloutMsg: tooManyBucketsCalloutMsg,
      showSelectedInterval: showSelectedInterval,
      chartsService: chartsService,
      showFilterIcons: showFilterIcons,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 454,
        columnNumber: 17
      }
    }));
  })));
};
exports.ExplorerChartsContainerUI = ExplorerChartsContainerUI;
const ExplorerChartsContainer = exports.ExplorerChartsContainer = (0, _public.withKibana)(ExplorerChartsContainerUI);