"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapActionButtonText = exports.MapButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_management/components/action_map/map_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const mapActionButtonText = exports.mapActionButtonText = _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.mapActionName', {
  defaultMessage: 'Map'
});
const MapButton = ({
  item
}) => {
  const disabled = !(0, _mlDataFrameAnalyticsUtils.isRegressionAnalysis)(item.config.analysis) && !(0, _mlDataFrameAnalyticsUtils.isOutlierAnalysis)(item.config.analysis) && !(0, _mlDataFrameAnalyticsUtils.isClassificationAnalysis)(item.config.analysis);
  if (disabled) {
    const toolTipContent = _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.mapActionDisabledTooltipContent', {
      defaultMessage: 'Unknown analysis type.'
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: toolTipContent,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      tabIndex: 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 9
      }
    }, mapActionButtonText));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, mapActionButtonText);
};
exports.MapButton = MapButton;