"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataViewPrompt = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _kibana = require("../../../../../contexts/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_exploration/components/data_view_prompt/data_view_prompt.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DataViewPrompt = ({
  destIndex,
  color
}) => {
  const {
    services: {
      http: {
        basePath
      },
      application: {
        capabilities
      }
    }
  } = (0, _kibana.useMlKibana)();
  const {
    euiTheme: {
      size
    }
  } = (0, _eui.useEuiTheme)();
  const canCreateDataView = (0, _react.useMemo)(() => capabilities.savedObjectsManagement.edit === true || capabilities.indexPatterns.save === true, [capabilities]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: color !== null && color !== void 0 ? color : 'warning',
    css: {
      padding: `${size.s}`
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analytics.dataViewPromptMessage",
    defaultMessage: "No data view exists for index {destIndex}. ",
    values: {
      destIndex: destIndex !== null && destIndex !== void 0 ? destIndex : ''
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }), canCreateDataView === true ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analytics.dataViewPromptLink",
    defaultMessage: "{linkToDataViewManagement}{destIndex}.",
    values: {
      destIndex: destIndex ? ` for ${destIndex}` : '',
      linkToDataViewManagement: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: `${basePath.get()}/app/management/kibana/dataViews/create`,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 53,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.dataframe.analytics.dataViewPromptLinkText",
        defaultMessage: "Create a data view",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 57,
          columnNumber: 17
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 9
    }
  }) : null);
};
exports.DataViewPrompt = DataViewPrompt;