"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditorComponent = void 0;
var _codeEditor = require("@kbn/code-editor");
var _i18n = require("@kbn/i18n");
var _put___ml_data_frame_analytics__id__schema = _interopRequireDefault(require("@kbn/json-schemas/src/put___ml_data_frame_analytics__id__schema.json"));
var _monaco = require("@kbn/monaco");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_creation/components/create_analytics_advanced_editor/editor_component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EditorComponent = ({
  value,
  onChange,
  readOnly
}) => {
  return /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    languageId: 'json',
    height: 500,
    languageConfiguration: {
      autoClosingPairs: [{
        open: '{',
        close: '}'
      }]
    },
    value: value,
    onChange: onChange,
    options: {
      ariaLabel: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.advancedEditor.codeEditorAriaLabel', {
        defaultMessage: 'Advanced analytics job editor'
      }),
      automaticLayout: true,
      readOnly,
      fontSize: 12,
      scrollBeyondLastLine: false,
      quickSuggestions: true,
      minimap: {
        enabled: false
      },
      wordWrap: 'on',
      wrappingIndent: 'indent'
    },
    editorDidMount: editor => {
      var _editor$getModel, _monaco$languages$jso;
      const editorModelUri = (_editor$getModel = editor.getModel()) === null || _editor$getModel === void 0 ? void 0 : _editor$getModel.uri.toString();
      _monaco.monaco.languages.json.jsonDefaults.setDiagnosticsOptions({
        validate: true,
        enableSchemaRequest: false,
        schemaValidation: 'error',
        schemas: [...((_monaco$languages$jso = _monaco.monaco.languages.json.jsonDefaults.diagnosticsOptions.schemas) !== null && _monaco$languages$jso !== void 0 ? _monaco$languages$jso : []), {
          uri: editorModelUri,
          fileMatch: [editorModelUri],
          schema: _put___ml_data_frame_analytics__id__schema.default
        }]
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 21,
      columnNumber: 5
    }
  });
};
exports.EditorComponent = EditorComponent;