"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultiSelectPicker = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/multi_select_picker/multi_select_picker.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NoFilterItems = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSelectableMessage, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "minusInCircle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.multiSelectPicker.NoFiltersFoundMessage",
    defaultMessage: "No filters found",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 9
    }
  })));
};
const MultiSelectPicker = ({
  options,
  onChange,
  title,
  checkedOptions,
  dataTestSubj
}) => {
  const [items, setItems] = (0, _react.useState)(options);
  const [searchTerm, setSearchTerm] = (0, _react.useState)('');
  (0, _react.useEffect)(() => {
    if (searchTerm === '') {
      setItems(options);
    } else {
      const filteredOptions = options.filter(o => {
        var _o$value;
        return o === null || o === void 0 ? void 0 : (_o$value = o.value) === null || _o$value === void 0 ? void 0 : _o$value.includes(searchTerm);
      });
      setItems(filteredOptions);
    }
  }, [options, searchTerm]);
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onButtonClick = () => {
    setIsPopoverOpen(!isPopoverOpen);
  };
  const closePopover = () => {
    setIsPopoverOpen(false);
  };
  const handleOnChange = index => {
    if (!items[index] || !Array.isArray(checkedOptions) || onChange === undefined) {
      return;
    }
    const item = items[index];
    const foundIndex = checkedOptions.findIndex(fieldValue => fieldValue === item.value);
    if (foundIndex > -1) {
      onChange(checkedOptions.filter((_, idx) => idx !== foundIndex));
    } else {
      onChange([...checkedOptions, item.value]);
    }
  };
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    "data-test-subj": `${dataTestSubj}-button`,
    iconType: "arrowDown",
    onClick: onButtonClick,
    isSelected: isPopoverOpen,
    numFilters: items.length,
    hasActiveFilters: checkedOptions && checkedOptions.length > 0,
    numActiveFilters: checkedOptions && checkedOptions.length,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 5
    }
  }, title);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    ownFocus: true,
    "data-test-subj": `${dataTestSubj}-popover`,
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    compressed: true,
    onChange: e => setSearchTerm(e.target.value),
    "data-test-subj": `${dataTestSubj}-searchInput`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      maxHeight: 250,
      overflow: 'auto'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 9
    }
  }, Array.isArray(items) && items.length > 0 ? items.map((item, index) => {
    var _item$name;
    const checked = checkedOptions && checkedOptions.findIndex(fieldValue => fieldValue === item.value) > -1;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterSelectItem, {
      checked: checked ? 'on' : undefined,
      key: index,
      onClick: () => handleOnChange(index),
      style: {
        flexDirection: 'row'
      },
      "data-test-subj": `${dataTestSubj}-option-${item.value}${checked ? '-checked' : ''}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 17
      }
    }, (_item$name = item.name) !== null && _item$name !== void 0 ? _item$name : item.value);
  }) : /*#__PURE__*/_react.default.createElement(NoFilterItems, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 13
    }
  }))));
};
exports.MultiSelectPicker = MultiSelectPicker;