"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RevertModelSnapshotFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlDateUtils = require("@kbn/ml-date-utils");
var _mlParseInterval = require("@kbn/ml-parse-interval");
var _kibana = require("../../../contexts/kibana");
var _chart_loader = require("./chart_loader");
var _results_service = require("../../../services/results_service");
var _event_rate_chart = require("../../../jobs/new_job/pages/components/charts/event_rate_chart/event_rate_chart");
var _create_calendar = require("./create_calendar");
var _toast_notification_service = require("../../../services/toast_notification_service");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/model_snapshots/revert_model_snapshot_flyout/revert_model_snapshot_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RevertModelSnapshotFlyout = ({
  snapshot,
  snapshots,
  job,
  closeFlyout,
  refresh
}) => {
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)();
  const confirmModalTitleId = (0, _eui.useGeneratedHtmlId)();
  const mlApi = (0, _kibana.useMlApi)();
  const {
    toasts
  } = (0, _kibana.useNotifications)();
  const {
    loadAnomalyDataForJob,
    loadEventRateForJob
  } = (0, _react.useMemo)(() => (0, _chart_loader.chartLoaderProvider)((0, _results_service.mlResultsServiceProvider)(mlApi)),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  const [currentSnapshot, setCurrentSnapshot] = (0, _react.useState)(snapshot);
  const [revertModalVisible, setRevertModalVisible] = (0, _react.useState)(false);
  const [replay, setReplay] = (0, _react.useState)(false);
  const [runInRealTime, setRunInRealTime] = (0, _react.useState)(false);
  const [createCalendar, setCreateCalendar] = (0, _react.useState)(false);
  const [calendarEvents, setCalendarEvents] = (0, _react.useState)([]);
  const [calendarEventsValid, setCalendarEventsValid] = (0, _react.useState)(true);
  const [eventRateData, setEventRateData] = (0, _react.useState)([]);
  const [anomalies, setAnomalies] = (0, _react.useState)([]);
  const [chartReady, setChartReady] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    createChartData();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [currentSnapshot]);
  (0, _react.useEffect)(() => {
    const invalid = calendarEvents.some(c => c.description === '' || c.end === null || c.start === null);
    setCalendarEventsValid(invalid === false);

    // a bug in elastic charts selection can
    // cause duplicate selected areas to be added
    // dedupe the calendars based on start and end times
    const calMap = new Map(calendarEvents.map(c => {
      var _c$start, _c$end;
      return [`${(_c$start = c.start) === null || _c$start === void 0 ? void 0 : _c$start.valueOf()}${(_c$end = c.end) === null || _c$end === void 0 ? void 0 : _c$end.valueOf()}`, c];
    }));
    const dedupedCalendarEvents = [...calMap.values()];
    if (dedupedCalendarEvents.length < calendarEvents.length) {
      // deduped list is shorter, we must have removed something.
      setCalendarEvents(dedupedCalendarEvents);
    }
  }, [calendarEvents]);
  const createChartData = (0, _react.useCallback)(async () => {
    const bucketSpanMs = (0, _mlParseInterval.parseInterval)(job.analysis_config.bucket_span).asMilliseconds();
    const eventRate = await loadEventRateForJob(job, bucketSpanMs, 100);
    const anomalyData = await loadAnomalyDataForJob(job, bucketSpanMs, 100);
    setEventRateData(eventRate);
    if (anomalyData[0] !== undefined) {
      setAnomalies(anomalyData[0]);
    }
    setChartReady(true);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [job]);
  function showRevertModal() {
    setRevertModalVisible(true);
  }
  function hideRevertModal() {
    setRevertModalVisible(false);
  }
  async function applyRevert() {
    const end = replay && runInRealTime === false ? job.data_counts.latest_record_timestamp : undefined;
    try {
      const events = replay && createCalendar ? calendarEvents.filter(filterIncompleteEvents).map(c => ({
        start: c.start.valueOf(),
        end: c.end.valueOf(),
        description: c.description
      })) : undefined;
      mlApi.jobs.revertModelSnapshot(job.job_id, currentSnapshot.snapshot_id, replay, end, events).then(() => {
        toasts.addSuccess(_i18n.i18n.translate('xpack.ml.revertModelSnapshotFlyout.revertSuccessTitle', {
          defaultMessage: 'Model snapshot revert successful'
        }));
        refresh();
      }).catch(error => {
        const {
          displayErrorToast
        } = (0, _toast_notification_service.toastNotificationServiceProvider)(toasts);
        displayErrorToast(error);
      });
      hideRevertModal();
      closeFlyout();
    } catch (error) {
      toasts.addError(new Error(error.body.message), {
        title: _i18n.i18n.translate('xpack.ml.revertModelSnapshotFlyout.revertErrorTitle', {
          defaultMessage: 'Model snapshot revert failed'
        })
      });
    }
  }
  function onSnapshotChange(ssId) {
    const ss = snapshots.find(s => s.snapshot_id === ssId);
    if (ss !== undefined) {
      setCurrentSnapshot(ss);
    }
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: closeFlyout,
    hideCloseButton: true,
    size: "m",
    "aria-labelledby": flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    id: flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.revertModelSnapshotFlyout.title",
    defaultMessage: "Revert to model snapshot {ssId}",
    values: {
      ssId: currentSnapshot.snapshot_id
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 13
    }
  }, currentSnapshot.description))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 9
    }
  }, false &&
  /*#__PURE__*/
  // disabled for now
  _react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.ml.newJob.wizard.revertModelSnapshotFlyout.changeSnapshotLabel', {
      defaultMessage: 'Change snapshot'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    options: snapshots.map(s => ({
      value: s.snapshot_id,
      inputDisplay: s.snapshot_id,
      dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 216,
          columnNumber: 27
        }
      }, s.snapshot_id), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 217,
          columnNumber: 27
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 218,
          columnNumber: 29
        }
      }, s.description)))
    })).reverse(),
    valueOfSelected: currentSnapshot.snapshot_id,
    onChange: onSnapshotChange,
    itemLayoutAlign: "top",
    hasDividers: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_event_rate_chart.EventRateChart, {
    eventRateChartData: eventRateData,
    anomalyData: anomalies,
    loading: chartReady === false,
    height: '100px',
    width: '100%',
    fadeChart: true,
    overlayRanges: [{
      start: currentSnapshot.latest_record_time_stamp,
      end: job.data_counts.latest_record_timestamp,
      color: '#ff0000'
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.revertModelSnapshotFlyout.warningCallout.title', {
      defaultMessage: 'Anomaly data will be deleted'
    }),
    color: "warning",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.revertModelSnapshotFlyout.warningCallout.contents",
    defaultMessage: "All anomaly detection results after {date} will be deleted.",
    values: {
      date: (0, _mlDateUtils.timeFormatter)(currentSnapshot.latest_record_time_stamp)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 271,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: _i18n.i18n.translate('xpack.ml.newJob.wizard.revertModelSnapshotFlyout.replaySwitchHelp', {
      defaultMessage: 'Reopen job and replay analysis after the revert has been applied.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    id: "replaySwitch",
    label: _i18n.i18n.translate('xpack.ml.newJob.wizard.revertModelSnapshotFlyout.replaySwitchLabel', {
      defaultMessage: 'Replay analysis'
    }),
    checked: replay,
    onChange: e => setReplay(e.target.checked),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 282,
      columnNumber: 13
    }
  })), replay && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: _i18n.i18n.translate('xpack.ml.newJob.wizard.revertModelSnapshotFlyout.realTimeSwitchHelp', {
      defaultMessage: 'Job will continue to run until manually stopped. All new data added to the index will be analyzed.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 297,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    id: "realTimeSwitch",
    label: _i18n.i18n.translate('xpack.ml.newJob.wizard.revertModelSnapshotFlyout.realTimeSwitchLabel', {
      defaultMessage: 'Run job in real time'
    }),
    checked: runInRealTime,
    onChange: e => setRunInRealTime(e.target.checked),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: _i18n.i18n.translate('xpack.ml.newJob.wizard.revertModelSnapshotFlyout.createCalendarSwitchHelp', {
      defaultMessage: 'Create a new calendar and event to skip over a period of time when analyzing the data.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 320,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    id: "createCalendarSwitch",
    label: _i18n.i18n.translate('xpack.ml.newJob.wizard.revertModelSnapshotFlyout.createCalendarSwitchLabel', {
      defaultMessage: 'Create calendar to skip a range of time'
    }),
    checked: createCalendar,
    onChange: e => setCreateCalendar(e.target.checked),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 330,
      columnNumber: 17
    }
  })), createCalendar && /*#__PURE__*/_react.default.createElement(_create_calendar.CreateCalendar, {
    calendarEvents: calendarEvents,
    setCalendarEvents: setCalendarEvents,
    minSelectableTimeStamp: snapshot.latest_record_time_stamp,
    maxSelectableTimeStamp: job.data_counts.latest_record_timestamp,
    eventRateData: eventRateData,
    anomalies: anomalies,
    chartReady: chartReady,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 344,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 357,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 358,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 359,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: closeFlyout,
    flush: "left",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 360,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.revertModelSnapshotFlyout.closeButton",
    defaultMessage: "Close",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 361,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 367,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 369,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: showRevertModal,
    disabled: createCalendar === true && calendarEventsValid === false,
    fill: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 370,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.revertModelSnapshotFlyout.saveButton",
    defaultMessage: "Apply",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 375,
      columnNumber: 17
    }
  })))))), revertModalVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": confirmModalTitleId,
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.revertModelSnapshotFlyout.deleteTitle', {
      defaultMessage: 'Apply snapshot revert'
    }),
    titleProps: {
      id: confirmModalTitleId
    },
    onCancel: hideRevertModal,
    onConfirm: applyRevert,
    cancelButtonText: _i18n.i18n.translate('xpack.ml.newJob.wizard.revertModelSnapshotFlyout.cancelButton', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.ml.newJob.wizard.revertModelSnapshotFlyout.deleteButton', {
      defaultMessage: 'Apply'
    }),
    buttonColor: "danger",
    defaultFocusedButton: "confirm",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 385,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.revertModelSnapshotFlyout.modalBody",
    defaultMessage: "The snapshot revert will be carried out in the background and may take some time.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 408,
      columnNumber: 11
    }
  })));
};
exports.RevertModelSnapshotFlyout = RevertModelSnapshotFlyout;
function filterIncompleteEvents(event) {
  return event.start !== null && event.end !== null;
}