"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ModelSnapshotTable = exports.COMBINED_JOB_STATE = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _mlDateUtils = require("@kbn/ml-date-utils");
var _kibana = require("../../contexts/kibana");
var _check_capabilities = require("../../capabilities/check_capabilities");
var _edit_model_snapshot_flyout = require("./edit_model_snapshot_flyout");
var _revert_model_snapshot_flyout = require("./revert_model_snapshot_flyout");
var _states = require("../../../../common/constants/states");
var _close_job_confirm = require("./close_job_confirm");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/model_snapshots/model_snapshots_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
let COMBINED_JOB_STATE = exports.COMBINED_JOB_STATE = /*#__PURE__*/function (COMBINED_JOB_STATE) {
  COMBINED_JOB_STATE[COMBINED_JOB_STATE["OPEN_AND_RUNNING"] = 0] = "OPEN_AND_RUNNING";
  COMBINED_JOB_STATE[COMBINED_JOB_STATE["OPEN_AND_STOPPED"] = 1] = "OPEN_AND_STOPPED";
  COMBINED_JOB_STATE[COMBINED_JOB_STATE["CLOSED"] = 2] = "CLOSED";
  COMBINED_JOB_STATE[COMBINED_JOB_STATE["UNKNOWN"] = 3] = "UNKNOWN";
  return COMBINED_JOB_STATE;
}({});
const ModelSnapshotTable = ({
  job,
  refreshJobList
}) => {
  const mlApi = (0, _kibana.useMlApi)();
  const [canCreateJob, canStartStopDatafeed] = (0, _check_capabilities.usePermissionCheck)(['canCreateJob', 'canStartStopDatafeed']);
  const [snapshots, setSnapshots] = (0, _react.useState)([]);
  const [snapshotsLoaded, setSnapshotsLoaded] = (0, _react.useState)(false);
  const [editSnapshot, setEditSnapshot] = (0, _react.useState)(null);
  const [revertSnapshot, setRevertSnapshot] = (0, _react.useState)(null);
  const [closeJobModalVisible, setCloseJobModalVisible] = (0, _react.useState)(null);
  const [combinedJobState, setCombinedJobState] = (0, _react.useState)(null);
  const actionsEnabled = (0, _react.useMemo)(() => job.blocked === undefined, [job]);
  const isMounted = (0, _react.useRef)(true);
  (0, _react.useEffect)(() => {
    loadModelSnapshots();
    return () => {
      isMounted.current = false;
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  async function loadModelSnapshots() {
    if (isMounted.current === false) {
      // table refresh can be triggered a while after a snapshot revert has been triggered.
      // ensure the table is still visible before attempted to refresh it.
      return;
    }
    const {
      model_snapshots: ms
    } = await mlApi.getModelSnapshots(job.job_id);
    setSnapshots(ms);
    setSnapshotsLoaded(true);
  }
  const checkJobIsClosed = (0, _react.useCallback)(async snapshot => {
    const jobs = await mlApi.jobs.jobs([job.job_id]);
    const state = getCombinedJobState(jobs);
    if (state === COMBINED_JOB_STATE.UNKNOWN) {
      // this will only happen if the job has been deleted by another user
      // between the time the row has been expended and now
      // eslint-disable-next-line no-console
      console.error(`Error retrieving state for job ${job.job_id}`);
      return;
    }
    setCombinedJobState(state);
    if (state === COMBINED_JOB_STATE.CLOSED) {
      // show flyout
      setRevertSnapshot(snapshot);
    } else {
      // show close job modal
      setCloseJobModalVisible(snapshot);
    }
  },
  // skip mlApi from deps
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [job]);
  function hideCloseJobModalVisible() {
    setCombinedJobState(null);
    setCloseJobModalVisible(null);
  }
  const forceCloseJob = (0, _react.useCallback)(async () => {
    await mlApi.jobs.forceStopAndCloseJob(job.job_id);
    if (closeJobModalVisible !== null) {
      const jobs = await mlApi.jobs.jobs([job.job_id]);
      const state = getCombinedJobState(jobs);
      if (state === COMBINED_JOB_STATE.CLOSED) {
        setRevertSnapshot(closeJobModalVisible);
      }
    }
    hideCloseJobModalVisible();
    // skip mlApi from deps
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [job, closeJobModalVisible]);
  const closeEditFlyout = (0, _react.useCallback)(reload => {
    setEditSnapshot(null);
    if (reload) {
      loadModelSnapshots();
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const closeRevertFlyout = (0, _react.useCallback)(() => {
    setRevertSnapshot(null);
  }, []);
  const refresh = (0, _react.useCallback)(() => {
    loadModelSnapshots();
    // wait half a second before refreshing the jobs list
    setTimeout(refreshJobList, 500);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const columns = [{
    field: 'snapshot_id',
    name: _i18n.i18n.translate('xpack.ml.modelSnapshotTable.id', {
      defaultMessage: 'ID'
    }),
    sortable: true
  }, {
    field: 'description',
    name: _i18n.i18n.translate('xpack.ml.modelSnapshotTable.description', {
      defaultMessage: 'Description'
    }),
    sortable: true
  }, {
    field: 'timestamp',
    name: _i18n.i18n.translate('xpack.ml.modelSnapshotTable.time', {
      defaultMessage: 'Date created'
    }),
    dataType: 'date',
    render: _mlDateUtils.timeFormatter,
    sortable: true
  }, {
    field: 'latest_record_time_stamp',
    name: _i18n.i18n.translate('xpack.ml.modelSnapshotTable.latestTimestamp', {
      defaultMessage: 'Latest timestamp'
    }),
    dataType: 'date',
    render: _mlDateUtils.timeFormatter,
    sortable: true
  }, {
    field: 'retain',
    name: _i18n.i18n.translate('xpack.ml.modelSnapshotTable.retain', {
      defaultMessage: 'Retain'
    }),
    width: '100px',
    sortable: true
  }, {
    field: '',
    width: '100px',
    name: _i18n.i18n.translate('xpack.ml.modelSnapshotTable.actions', {
      defaultMessage: 'Actions'
    }),
    actions: [{
      name: _i18n.i18n.translate('xpack.ml.modelSnapshotTable.actions.revert.name', {
        defaultMessage: 'Revert'
      }),
      description: _i18n.i18n.translate('xpack.ml.modelSnapshotTable.actions.revert.description', {
        defaultMessage: 'Revert to this snapshot'
      }),
      enabled: () => actionsEnabled && canCreateJob && canStartStopDatafeed,
      type: 'icon',
      icon: 'crosshairs',
      onClick: checkJobIsClosed,
      'data-test-subj': `mlADModelSnapShotRevertButton`
    }, {
      name: _i18n.i18n.translate('xpack.ml.modelSnapshotTable.actions.edit.name', {
        defaultMessage: 'Edit'
      }),
      description: _i18n.i18n.translate('xpack.ml.modelSnapshotTable.actions.edit.description', {
        defaultMessage: 'Edit this snapshot'
      }),
      enabled: () => actionsEnabled && canCreateJob,
      type: 'icon',
      icon: 'pencil',
      onClick: setEditSnapshot,
      'data-test-subj': `mlADModelSnapShotsEditButton`
    }]
  }];
  if (snapshotsLoaded === false) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceAround",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 220,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 221,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 222,
        columnNumber: 13
      }
    }))));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    className: "eui-textBreakWord",
    compressed: true,
    items: snapshots,
    columns: columns,
    pagination: {
      pageSizeOptions: [5, 10, 25]
    },
    sorting: {
      sort: {
        field: 'timestamp',
        direction: 'asc'
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 7
    }
  }), editSnapshot !== null && /*#__PURE__*/_react.default.createElement(_edit_model_snapshot_flyout.EditModelSnapshotFlyout, {
    snapshot: editSnapshot,
    job: job,
    closeFlyout: closeEditFlyout,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 9
    }
  }), revertSnapshot !== null && /*#__PURE__*/_react.default.createElement(_revert_model_snapshot_flyout.RevertModelSnapshotFlyout, {
    snapshot: revertSnapshot,
    snapshots: snapshots,
    job: job,
    closeFlyout: closeRevertFlyout,
    refresh: refresh,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 9
    }
  }), closeJobModalVisible !== null && combinedJobState !== null && /*#__PURE__*/_react.default.createElement(_close_job_confirm.CloseJobConfirm, {
    combinedJobState: combinedJobState,
    hideCloseJobModalVisible: hideCloseJobModalVisible,
    forceCloseJob: forceCloseJob,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 9
    }
  }));
};
exports.ModelSnapshotTable = ModelSnapshotTable;
function getCombinedJobState(jobs) {
  if (jobs.length !== 1) {
    return COMBINED_JOB_STATE.UNKNOWN;
  }
  if (jobs[0].state !== _states.JOB_STATE.CLOSED) {
    if (jobs[0].datafeed_config.state !== _states.DATAFEED_STATE.STOPPED) {
      return COMBINED_JOB_STATE.OPEN_AND_RUNNING;
    }
    return COMBINED_JOB_STATE.OPEN_AND_STOPPED;
  }
  return COMBINED_JOB_STATE.CLOSED;
}