"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExportJobDependenciesWarningCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/import_export_jobs/export_jobs_flyout/export_job_warning_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ExportJobDependenciesWarningCallout = ({
  jobs: allJobs
}) => {
  const [jobs, jobsWithCalendars, jobsWithFilters] = filterJobs(allJobs);
  const usingCalendars = jobsWithCalendars.length > 0;
  const usingFilters = jobsWithFilters.length > 0;
  if (usingCalendars === false && usingFilters === false) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: getTitle(jobs, jobsWithCalendars.length, jobsWithFilters.length),
    color: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.importExport.exportFlyout.exportJobDependenciesWarningCallout.calendarDependencies",
    defaultMessage: "When you export jobs, calendars and filter lists are not included. You must create the filter lists before you import jobs; otherwise, the import fails. If you want the new jobs to continue to ignore scheduled events, you must create the calendars.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 9
    }
  }), usingCalendars && /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "advancedOptions",
    paddingSize: "s",
    "aria-label": _i18n.i18n.translate('xpack.ml.importExport.exportFlyout.exportJobDependenciesWarningCallout.jobUsingCalendarsAria', {
      defaultMessage: 'Jobs using calendars'
    }),
    buttonContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.importExport.exportFlyout.exportJobDependenciesWarningCallout.jobUsingCalendarsButton",
      defaultMessage: "Jobs using calendars",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(CalendarJobList, {
    jobs: jobsWithCalendars,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 13
    }
  })), usingFilters && /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "advancedOptions",
    paddingSize: "s",
    "aria-label": _i18n.i18n.translate('xpack.ml.importExport.exportFlyout.exportJobDependenciesWarningCallout.jobUsingFiltersAria', {
      defaultMessage: 'Jobs using filter lists'
    }),
    buttonContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.importExport.exportFlyout.exportJobDependenciesWarningCallout.jobUsingFiltersButton",
      defaultMessage: "Jobs using filter lists",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(FilterJobList, {
    jobs: jobsWithFilters,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }));
};
exports.ExportJobDependenciesWarningCallout = ExportJobDependenciesWarningCallout;
const CalendarJobList = ({
  jobs
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, jobs.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, jobs.map(({
  jobId,
  calendarIds
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 95,
    columnNumber: 13
  }
}, /*#__PURE__*/_react.default.createElement("h5", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 96,
    columnNumber: 15
  }
}, jobId), calendarIds.length > 0 && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.ml.importExport.exportFlyout.exportJobDependenciesWarningCallout.calendarList",
  defaultMessage: "{num, plural, one {calendar} other {calendars}}: {calendars}",
  values: {
    num: calendarIds.length,
    calendars: calendarIds.join(', ')
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 98,
    columnNumber: 17
  }
})), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 105,
    columnNumber: 13
  }
})))));
const FilterJobList = ({
  jobs
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, jobs.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, jobs.map(({
  jobId,
  filterIds
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 119,
    columnNumber: 13
  }
}, /*#__PURE__*/_react.default.createElement("h5", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 120,
    columnNumber: 15
  }
}, jobId), filterIds.length > 0 && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.ml.importExport.exportFlyout.exportJobDependenciesWarningCallout.filterList",
  defaultMessage: "Filter {num, plural, one {list} other {lists}}: {filters}",
  values: {
    num: filterIds.length,
    filters: filterIds.join(', ')
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 122,
    columnNumber: 17
  }
})), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 129,
    columnNumber: 13
  }
})))));
function getTitle(jobs, calendarCount, filterCount) {
  if (calendarCount > 0 && filterCount === 0) {
    return _i18n.i18n.translate('xpack.ml.importExport.exportFlyout.exportJobDependenciesWarningCallout.calendarOnlyTitle', {
      defaultMessage: '{jobCount, plural, one {# job uses} other {# jobs use}} {calendarCount, plural, one {a calendar} other {calendars}}',
      values: {
        jobCount: jobs.length,
        calendarCount
      }
    });
  }
  if (calendarCount === 0 && filterCount > 0) {
    return _i18n.i18n.translate('xpack.ml.importExport.exportFlyout.exportJobDependenciesWarningCallout.filterOnlyTitle', {
      defaultMessage: '{jobCount, plural, one {# job uses} other {# jobs use}} {filterCount, plural, one {a filter list} other {filter lists}}',
      values: {
        jobCount: jobs.length,
        filterCount
      }
    });
  }
  return _i18n.i18n.translate('xpack.ml.importExport.exportFlyout.exportJobDependenciesWarningCallout.filterAndCalendarTitle', {
    defaultMessage: '{jobCount, plural, one {# job uses} other {# jobs use}} filter lists and calendars',
    values: {
      jobCount: jobs.length
    }
  });
}
function filterJobs(jobs) {
  return jobs.reduce((acc, job) => {
    const usingCalendars = job.calendarIds.length > 0;
    const usingFilters = job.filterIds.length > 0;
    if (usingCalendars || usingFilters) {
      acc[0].push(job);
      if (usingCalendars) {
        acc[1].push(job);
      }
      if (usingFilters) {
        acc[2].push(job);
      }
    }
    return acc;
  }, [[], [], []]);
}