"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomUrls = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _toast_notification_service = require("../../services/toast_notification_service");
var _custom_url_editor = require("./custom_url_editor");
var _utils = require("./custom_url_editor/utils");
var _custom_url_utils = require("../../util/custom_url_utils");
var _index_service = require("../../util/index_service");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/custom_urls/custom_urls.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class CustomUrls extends _react.Component {
  constructor(props, constructorContext) {
    super(props);
    (0, _defineProperty2.default)(this, "toastNotificationService", void 0);
    (0, _defineProperty2.default)(this, "mlIndexUtils", void 0);
    (0, _defineProperty2.default)(this, "editNewCustomUrl", () => {
      // Opens the editor for configuring a new custom URL.
      this.setState(prevState => {
        const {
          dashboards,
          dataViewListItems
        } = prevState;
        return {
          editorOpen: true,
          editorSettings: (0, _utils.getNewCustomUrlDefaults)(this.props.job, dashboards, dataViewListItems, this.props.isPartialDFAJob)
        };
      });
    });
    (0, _defineProperty2.default)(this, "setEditCustomUrl", customUrl => {
      this.setState({
        editorSettings: customUrl
      });
    });
    (0, _defineProperty2.default)(this, "addNewCustomUrl", () => {
      const {
        dashboard,
        share
      } = this.context.services;
      (0, _utils.buildCustomUrlFromSettings)(dashboard, share, this.state.editorSettings).then(customUrl => {
        const customUrls = [...this.state.customUrls, customUrl];
        this.props.setCustomUrls(customUrls);
        this.setState({
          editorOpen: false
        });
      }).catch(error => {
        this.toastNotificationService.displayErrorToast(error, _i18n.i18n.translate('xpack.ml.jobsList.editJobFlyout.customUrls.addNewUrlErrorNotificationMessage', {
          defaultMessage: 'An error occurred building the new custom URL from the supplied settings'
        }));
      });
    });
    (0, _defineProperty2.default)(this, "onTestButtonClick", () => {
      var _this$state, _this$state$editorSet, _this$state$editorSet2;
      const {
        http: {
          basePath
        },
        data: {
          dataViews
        },
        dashboard,
        mlServices: {
          mlApi
        },
        share
      } = this.context.services;
      const dataViewId = (_this$state = this.state) === null || _this$state === void 0 ? void 0 : (_this$state$editorSet = _this$state.editorSettings) === null || _this$state$editorSet === void 0 ? void 0 : (_this$state$editorSet2 = _this$state$editorSet.kibanaSettings) === null || _this$state$editorSet2 === void 0 ? void 0 : _this$state$editorSet2.discoverIndexPatternId;
      const job = this.props.job;
      dataViews.get(dataViewId !== null && dataViewId !== void 0 ? dataViewId : '').catch(error => {
        // We still want to try to get the test URL as not all custom urls require a timefield to be passed.
        // eslint-disable-next-line no-console
        console.error('Error obtaining data view:', error);
      }).then(dataView => {
        var _dataView$timeFieldNa;
        const timefieldName = (_dataView$timeFieldNa = dataView === null || dataView === void 0 ? void 0 : dataView.timeFieldName) !== null && _dataView$timeFieldNa !== void 0 ? _dataView$timeFieldNa : null;
        (0, _utils.buildCustomUrlFromSettings)(dashboard, share, this.state.editorSettings).then(customUrl => {
          (0, _utils.getTestUrl)(mlApi, job, customUrl, timefieldName, this.props.currentTimeFilter, this.props.isPartialDFAJob).then(testUrl => {
            (0, _custom_url_utils.openCustomUrlWindow)(testUrl, customUrl, basePath.get());
          }).catch(error => {
            this.toastNotificationService.displayErrorToast(error, _i18n.i18n.translate('xpack.ml.jobsList.editJobFlyout.customUrls.getTestUrlErrorNotificationMessage', {
              defaultMessage: 'An error occurred obtaining the URL to test the configuration'
            }));
          });
        });
      }).catch(error => {
        this.toastNotificationService.displayErrorToast(error, _i18n.i18n.translate('xpack.ml.jobsList.editJobFlyout.customUrls.buildUrlErrorNotificationMessage', {
          defaultMessage: 'An error occurred building the custom URL for testing from the supplied settings'
        }));
      });
    });
    (0, _defineProperty2.default)(this, "closeEditor", () => {
      this.setState({
        editorOpen: false
      });
    });
    this.state = {
      customUrls: [],
      dashboards: [],
      dataViewListItems: [],
      editorOpen: false,
      supportedFilterFields: []
    };
    this.toastNotificationService = (0, _toast_notification_service.toastNotificationServiceProvider)(constructorContext.services.notifications.toasts);
    this.mlIndexUtils = (0, _index_service.indexServiceFactory)(constructorContext.services.data.dataViews);
  }
  static getDerivedStateFromProps(props) {
    return {
      job: props.job,
      customUrls: props.jobCustomUrls
    };
  }
  componentDidMount() {
    const {
      dashboardService
    } = this.props;
    dashboardService.fetchDashboards().then(dashboards => {
      this.setState({
        dashboards
      });
    }).catch(error => {
      this.toastNotificationService.displayErrorToast(error, _i18n.i18n.translate('xpack.ml.jobsList.editJobFlyout.customUrls.loadSavedDashboardsErrorNotificationMessage', {
        defaultMessage: 'An error occurred loading the list of saved Kibana dashboards'
      }));
    });
    this.mlIndexUtils.loadDataViewListItems().then(dataViewListItems => {
      this.setState({
        dataViewListItems
      });
    }).catch(error => {
      this.toastNotificationService.displayErrorToast(error, _i18n.i18n.translate('xpack.ml.jobsList.editJobFlyout.customUrls.loadDataViewsErrorNotificationMessage', {
        defaultMessage: 'An error occurred loading the list of saved data views'
      }));
    });
  }
  renderEditor() {
    var _this$props$editMode;
    const {
      customUrls,
      editorOpen,
      editorSettings,
      dashboards,
      dataViewListItems
    } = this.state;
    const editMode = (_this$props$editMode = this.props.editMode) !== null && _this$props$editMode !== void 0 ? _this$props$editMode : 'inline';
    const editor = /*#__PURE__*/_react.default.createElement(_custom_url_editor.CustomUrlEditor, {
      showCustomTimeRangeSelector: (0, _mlDataFrameAnalyticsUtils.isDataFrameAnalyticsConfigs)(this.props.job) || this.props.isPartialDFAJob === true,
      customUrl: editorSettings,
      setEditCustomUrl: this.setEditCustomUrl,
      savedCustomUrls: customUrls,
      dashboards: dashboards,
      dataViewListItems: dataViewListItems,
      job: this.props.job,
      isPartialDFAJob: this.props.isPartialDFAJob,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 248,
        columnNumber: 7
      }
    });
    const isValidEditorSettings = editorOpen && editorSettings !== undefined ? (0, _utils.isValidCustomUrlSettings)(editorSettings, customUrls) : true;
    const addButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: this.addNewCustomUrl,
      isDisabled: !isValidEditorSettings,
      "data-test-subj": "mlJobAddCustomUrl",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 268,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.editJobFlyout.customUrls.addButtonLabel",
      defaultMessage: "Add",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 273,
        columnNumber: 9
      }
    }));
    const testButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      iconType: "popout",
      iconSide: "right",
      onClick: this.onTestButtonClick,
      isDisabled: !isValidEditorSettings,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 281,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.editJobFlyout.customUrls.testButtonLabel",
      defaultMessage: "Test",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 287,
        columnNumber: 9
      }
    }));
    return editMode === 'inline' ? /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      className: "edit-custom-url-panel",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 295,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      color: "text",
      onClick: this.closeEditor,
      iconType: "cross",
      "aria-label": _i18n.i18n.translate('xpack.ml.jobsList.editJobFlyout.customUrls.closeEditorAriaLabel', {
        defaultMessage: 'Close custom URL editor'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 296,
        columnNumber: 9
      }
    }), editor, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 310,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 311,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 312,
        columnNumber: 11
      }
    }, addButton), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 313,
        columnNumber: 11
      }
    }, testButton))) : /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
      onClose: this.closeEditor,
      initialFocus: "[name=label]",
      style: {
        width: 500
      },
      "data-test-subj": "mlJobNewCustomUrlFormModal",
      "aria-label": _i18n.i18n.translate('xpack.ml.jobsList.editJobFlyout.customUrls.addCustomUrlAriaLabel', {
        defaultMessage: 'Add custom URL to the job'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 317,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 329,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 330,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.editJobFlyout.customUrls.addCustomUrlButtonLabel",
      defaultMessage: "Add custom URL",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 331,
        columnNumber: 13
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 338,
        columnNumber: 9
      }
    }, editor), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 340,
        columnNumber: 9
      }
    }, testButton, addButton));
  }
  render() {
    const {
      customUrls,
      editorOpen
    } = this.state;
    const {
      editMode = 'inline'
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 354,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      "aria-live": "polite",
      "aria-atomic": "true",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 355,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h2", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 356,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.customUrls.screenReader.configurationTitle",
      defaultMessage: "Custom URL Configuration",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 357,
        columnNumber: 15
      }
    })), customUrls.length === 0 ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.customUrls.screenReader.noConfiguredUrls",
      defaultMessage: "No custom URLs configured",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 363,
        columnNumber: 15
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.customUrls.screenReader.configuredUrlsCount",
      defaultMessage: "{count, plural, one {# custom URL} other {# custom URLs}} configured",
      values: {
        count: customUrls.length
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 368,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 376,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_custom_url_editor.CustomUrlList, {
      job: this.props.job,
      customUrls: customUrls,
      onChange: this.props.setCustomUrls,
      dataViewListItems: this.state.dataViewListItems,
      isPartialDFAJob: this.props.isPartialDFAJob,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 377,
        columnNumber: 9
      }
    }), (!editorOpen || editMode === 'modal') && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      iconType: "plusInCircle",
      iconSide: "left",
      "aria-label": _i18n.i18n.translate('xpack.ml.jobsList.editJobFlyout.customUrls.addCustomUrlButtonLabel', {
        defaultMessage: 'Add custom URL'
      }),
      onClick: this.editNewCustomUrl,
      "data-test-subj": "mlJobOpenCustomUrlFormButton",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 386,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.editJobFlyout.customUrls.addCustomUrlButtonLabel",
      defaultMessage: "Add custom URL",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 397,
        columnNumber: 15
      }
    }))), editorOpen && this.renderEditor());
  }
}
exports.CustomUrls = CustomUrls;
(0, _defineProperty2.default)(CustomUrls, "contextType", _public.context);