"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpandButton = ExpandButton;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/connected_components/right_side_controls/layer_control/expand_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ExpandButton({
  hasErrorsOrWarnings,
  isLoading,
  onClick
}) {
  // isLoading indicates at least one layer is loading.
  // Expand button should never be disabled.
  // Not using EuiButton* with iconType props because EuiButton* disables button when isLoading prop is true.
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": _i18n.i18n.translate('xpack.maps.layerControl.openLayerTOCButtonAriaLabel', {
      defaultMessage: 'Expand layers panel'
    }),
    className: "mapLayerControl__openLayerTOCButton",
    color: "text",
    onClick: onClick,
    "data-test-subj": "mapExpandLayerControlButton",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 5
    }
  }, isLoading ? /*#__PURE__*/_react.default.createElement("div", {
    style: {
      paddingTop: '6px'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 11
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: hasErrorsOrWarnings ? 'warning' : 'menuLeft',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 9
    }
  }));
}