"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GlobalTimeCheckbox = GlobalTimeCheckbox;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/components/global_time_checkbox.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function GlobalTimeCheckbox({
  applyGlobalTime,
  label,
  setApplyGlobalTime,
  isFeatureEditorOpenForLayer
}) {
  const onApplyGlobalTimeChange = event => {
    setApplyGlobalTime(event.target.checked);
  };
  const tooltipMessage = isFeatureEditorOpenForLayer ? _i18n.i18n.translate('xpack.maps.filterEditor.isGlobalTimeNotApplied', {
    defaultMessage: 'Global time is not applied to the layer while editing features'
  }) : _i18n.i18n.translate('xpack.maps.filterEditor.applyGlobalTimeHelp', {
    defaultMessage: 'When enabled, results narrowed by global time'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: tooltipMessage,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: label,
    checked: isFeatureEditorOpenForLayer ? false : applyGlobalTime,
    onChange: onApplyGlobalTimeChange,
    "data-test-subj": "mapLayerPanelApplyGlobalTimeCheckbox",
    compressed: true,
    disabled: isFeatureEditorOpenForLayer,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 9
    }
  })));
}