"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IconMapSelect = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _icon_stops = require("./icon_stops");
var _symbol_utils = require("../../symbol_utils");
var _constants = require("../../../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/styles/vector/components/symbol/icon_map_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CUSTOM_MAP_ID = 'CUSTOM_MAP_ID';
const DEFAULT_ICON_STOPS = [{
  stop: null,
  icon: _symbol_utils.PREFERRED_ICONS[0],
  iconSource: _constants.ICON_SOURCE.MAKI
},
// first stop is the "other" category
{
  stop: '',
  icon: _symbol_utils.PREFERRED_ICONS[1],
  iconSource: _constants.ICON_SOURCE.MAKI
}];
class IconMapSelect extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      customIconStops: this.props.customIconStops ? this.props.customIconStops : DEFAULT_ICON_STOPS
    });
    (0, _defineProperty2.default)(this, "_onMapSelect", selectedValue => {
      const useCustomIconMap = selectedValue === CUSTOM_MAP_ID;
      const changes = {
        iconPaletteId: useCustomIconMap ? null : selectedValue,
        useCustomIconMap
      };
      // edge case when custom palette is first enabled
      // customIconStops is undefined so need to update custom stops with default so icons are rendered.
      if (!this.props.customIconStops) {
        changes.customIconStops = DEFAULT_ICON_STOPS;
      }
      this.props.onChange(changes);
    });
    (0, _defineProperty2.default)(this, "_onCustomMapChange", ({
      customStops,
      isInvalid
    }) => {
      // Manage invalid custom map in local state
      this.setState({
        customIconStops: customStops
      });
      if (!isInvalid) {
        this.props.onChange({
          useCustomIconMap: true,
          customIconStops: customStops
        });
      }
    });
  }
  _renderCustomStopsInput() {
    return !this.props.isCustomOnly && !this.props.useCustomIconMap ? null : /*#__PURE__*/_react.default.createElement(_icon_stops.IconStops, {
      field: this.props.styleProperty.getField(),
      getValueSuggestions: this.props.styleProperty.getValueSuggestions,
      iconStops: this.state.customIconStops,
      onChange: this._onCustomMapChange,
      onCustomIconsChange: this.props.onCustomIconsChange,
      customIcons: this.props.customIcons,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 7
      }
    });
  }
  _renderMapSelect() {
    if (this.props.isCustomOnly) {
      return null;
    }
    const mapOptionsWithCustom = [{
      value: CUSTOM_MAP_ID,
      inputDisplay: _i18n.i18n.translate('xpack.maps.styles.icon.customMapLabel', {
        defaultMessage: 'Custom icon palette'
      })
    }, ...(0, _symbol_utils.getIconPaletteOptions)()];
    let valueOfSelected = '';
    if (this.props.useCustomIconMap) {
      valueOfSelected = CUSTOM_MAP_ID;
    } else if (this.props.iconPaletteId) {
      valueOfSelected = this.props.iconPaletteId;
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
      options: mapOptionsWithCustom,
      onChange: this._onMapSelect,
      valueOfSelected: valueOfSelected,
      hasDividers: true,
      compressed: true,
      "aria-label": _i18n.i18n.translate('xpack.maps.styles.icon.iconPaletteSelectAriaLabel', {
        defaultMessage: 'Icon palette'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 9
      }
    }));
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 7
      }
    }, this._renderMapSelect(), this._renderCustomStopsInput());
  }
}
exports.IconMapSelect = IconMapSelect;