"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomIconModal = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _analytics = require("@kbn/analytics");
var _i18n = require("@kbn/i18n");
var _icon_preview = require("./icon_preview");
var _symbol_utils = require("../../symbol_utils");
var _validated_range = require("../../../../../components/validated_range");
var _common = require("../../../../../../common");
var _kibana_services = require("../../../../../kibana_services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/styles/vector/components/symbol/custom_icon_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const strings = {
  getAdvancedOptionsLabel: () => _i18n.i18n.translate('xpack.maps.customIconModal.advancedOptionsLabel', {
    defaultMessage: 'Advanced options'
  }),
  getCancelButtonLabel: () => _i18n.i18n.translate('xpack.maps.customIconModal.cancelButtonLabel', {
    defaultMessage: 'Cancel'
  }),
  getCutoffRangeLabel: () => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.maps.customIconModal.cutoffRangeTooltip', {
      defaultMessage: 'Adjusts the balance of the signed distance function between the inside (approaching 1) and outside (approaching 0) of the icon.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.maps.customIconModal.cutoffRangeLabel', {
    defaultMessage: 'Alpha threshold'
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: "subdued",
    type: "question",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 9
    }
  }))),
  getDeleteButtonLabel: () => _i18n.i18n.translate('xpack.maps.customIconModal.deleteButtonLabel', {
    defaultMessage: 'Delete'
  }),
  getImageFilePickerPlaceholder: () => _i18n.i18n.translate('xpack.maps.customIconModal.imageFilePickerPlaceholder', {
    defaultMessage: 'Select or drag and drop an SVG icon'
  }),
  getImageInputDescription: () => _i18n.i18n.translate('xpack.maps.customIconModal.imageInputDescription', {
    defaultMessage: 'SVGs without sharp corners and intricate details work best. Modifying the settings under Advanced options may improve rendering.'
  }),
  getInvalidFileLabel: () => _i18n.i18n.translate('xpack.maps.customIconModal.invalidFileError', {
    defaultMessage: 'Icon must be in SVG format. Other image types are not supported.'
  }),
  getNameInputLabel: () => _i18n.i18n.translate('xpack.maps.customIconModal.nameInputLabel', {
    defaultMessage: 'Name'
  }),
  getRadiusRangeLabel: () => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.maps.customIconModal.raduisRangeTooltip', {
      defaultMessage: 'Adjusts the size of the signed distance function around the Alpha threshold as a percent of icon size.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.maps.customIconModal.radiusRangeLabel', {
    defaultMessage: 'Radius'
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: "subdued",
    type: "question",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 9
    }
  }))),
  getResetButtonLabel: () => _i18n.i18n.translate('xpack.maps.customIconModal.resetButtonLabel', {
    defaultMessage: 'Reset'
  }),
  getSaveButtonLabel: () => _i18n.i18n.translate('xpack.maps.customIconModal.saveButtonLabel', {
    defaultMessage: 'Save'
  })
};
const styles = {
  wrapper: (0, _react2.css)({
    maxWidth: '210px',
    minHeight: '210px'
  }),
  iconForm: (0, _react2.css)({
    minWidth: '400px'
  })
};
function getFileNameWithoutExt(fileName) {
  const splits = fileName.split('.');
  if (splits.length > 1) {
    splits.pop();
  }
  return splits.join('.');
}
class CustomIconModal extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      label: this.props.label || '',
      svg: this.props.svg || '',
      cutoff: this.props.cutoff,
      radius: this.props.radius,
      isFileInvalid: this.props.svg ? false : true
    });
    (0, _defineProperty2.default)(this, "_handleLabelChange", value => {
      this.setState({
        label: value
      });
    });
    (0, _defineProperty2.default)(this, "_handleCutoffChange", value => {
      this.setState({
        cutoff: value
      });
    });
    (0, _defineProperty2.default)(this, "_handleRadiusChange", value => {
      this.setState({
        radius: value
      });
    });
    (0, _defineProperty2.default)(this, "_resetAdvancedOptions", () => {
      this.setState({
        radius: this.props.radius,
        cutoff: this.props.cutoff
      });
    });
    (0, _defineProperty2.default)(this, "_onFileSelect", async files => {
      this.setState({
        label: '',
        svg: '',
        isFileInvalid: false
      });
      if (files && files.length) {
        const file = files[0];
        const {
          type
        } = file;
        if (type === 'image/svg+xml') {
          var _this$props$label;
          const label = (_this$props$label = this.props.label) !== null && _this$props$label !== void 0 ? _this$props$label : getFileNameWithoutExt(file.name);
          try {
            const svg = await file.text();
            if (!this._isMounted) {
              return;
            }
            this.setState({
              isFileInvalid: false,
              label,
              svg
            });
          } catch (err) {
            if (!this._isMounted) {
              return;
            }
            this.setState({
              isFileInvalid: true
            });
          }
        } else {
          this.setState({
            isFileInvalid: true
          });
        }
      }
    });
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  componentDidMount() {
    this._isMounted = true;
  }
  _renderAdvancedOptions() {
    const {
      cutoff,
      radius
    } = this.state;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
      id: "advancedOptionsAccordion",
      buttonContent: strings.getAdvancedOptionsLabel(),
      paddingSize: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 248,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      color: "subdued",
      paddingSize: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 253,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexEnd",
      gutterSize: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 254,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 255,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      onClick: this._resetAdvancedOptions,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 256,
        columnNumber: 15
      }
    }, strings.getResetButtonLabel()))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      className: "mapsCustomIconForm__cutoff",
      label: strings.getCutoffRangeLabel(),
      display: "rowCompressed",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 261,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_validated_range.ValidatedRange, {
      min: 0,
      max: 1,
      value: cutoff,
      step: 0.01,
      showInput: true,
      showLabels: true,
      compressed: true,
      onChange: this._handleCutoffChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 266,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      className: "mapsCustomIconForm__radius",
      label: strings.getRadiusRangeLabel(),
      display: "rowCompressed",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 277,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_validated_range.ValidatedRange, {
      min: 0,
      max: 1,
      value: radius,
      step: 0.01,
      showInput: true,
      showLabels: true,
      compressed: true,
      className: "mapsRadiusRange",
      onChange: this._handleRadiusChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 282,
        columnNumber: 13
      }
    }))));
  }
  _renderIconForm() {
    const {
      label,
      svg
    } = this.state;
    return svg !== '' ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: strings.getNameInputLabel(),
      display: "rowCompressed",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 303,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: label,
      className: "mapsCustomIconForm__label",
      onChange: e => this._handleLabelChange(e.target.value),
      required: true,
      "data-test-subj": "mapsCustomIconForm-label",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 304,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 312,
        columnNumber: 9
      }
    }), this._renderAdvancedOptions()) : null;
  }
  _renderIconPreview() {
    const {
      svg,
      isFileInvalid,
      cutoff,
      radius
    } = this.state;
    return svg !== '' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      css: styles.wrapper,
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 321,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_icon_preview.IconPreview, {
      svg: svg,
      isSvgInvalid: isFileInvalid,
      cutoff: cutoff,
      radius: radius,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 322,
        columnNumber: 9
      }
    })) : null;
  }
  render() {
    const usageCollector = (0, _kibana_services.getUsageCollection)();
    const {
      symbolId,
      onSave,
      onCancel,
      onDelete,
      title
    } = this.props;
    const {
      label,
      svg,
      cutoff,
      radius,
      isFileInvalid
    } = this.state;
    const isComplete = label.length !== 0 && svg.length !== 0 && !isFileInvalid;
    const fileError = svg && isFileInvalid ? strings.getInvalidFileLabel() : '';
    return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
      className: "mapsCustomIconModal",
      maxWidth: 700,
      onClose: onCancel,
      initialFocus: ".mapsCustomIconForm__image",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 334,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 340,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
      component: "h3",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 341,
        columnNumber: 11
      }
    }, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 343,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      alignItems: "flexStart",
      gutterSize: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 344,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      css: styles.iconForm,
      grow: 2,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 345,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      className: "mapsCustomIconForm__image",
      display: "rowCompressed",
      isInvalid: !!fileError,
      error: fileError,
      helpText: strings.getImageInputDescription(),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 346,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
      initialPromptText: strings.getImageFilePickerPlaceholder(),
      onChange: this._onFileSelect,
      className: "mapsImageUpload",
      accept: ".svg",
      isInvalid: !!fileError,
      required: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 353,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 362,
        columnNumber: 15
      }
    }), this._renderIconForm()), this._renderIconPreview())), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 368,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexEnd",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 369,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 370,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: onCancel,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 371,
        columnNumber: 15
      }
    }, strings.getCancelButtonLabel())), onDelete && symbolId ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 374,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "danger",
      onClick: () => {
        usageCollector === null || usageCollector === void 0 ? void 0 : usageCollector.reportUiCounter(_common.APP_ID, _analytics.METRIC_TYPE.CLICK, 'settings_custom_icons_delete');
        onDelete(symbolId);
      },
      "data-test-subj": "mapsCustomIconForm-submit",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 375,
        columnNumber: 17
      }
    }, strings.getDeleteButtonLabel())) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 391,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      onClick: () => {
        if (!onDelete) {
          // Only report events when adding a new custom icon, not when editing an existing icon
          usageCollector === null || usageCollector === void 0 ? void 0 : usageCollector.reportUiCounter(_common.APP_ID, _analytics.METRIC_TYPE.CLICK, 'settings_custom_icons_add');
        }
        onSave({
          symbolId: symbolId !== null && symbolId !== void 0 ? symbolId : (0, _symbol_utils.getCustomIconId)(),
          label,
          svg,
          cutoff,
          radius
        });
      },
      "data-test-subj": "mapsCustomIconForm-submit",
      isDisabled: !isComplete,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 392,
        columnNumber: 15
      }
    }, strings.getSaveButtonLabel())))));
  }
}
exports.CustomIconModal = CustomIconModal;