"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColorStopsOrdinal = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _color_stops = require("./color_stops");
var _eui = require("@elastic/eui");
var _color_stops_utils = require("./color_stops_utils");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/styles/vector/components/color/color_stops_ordinal.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ColorStopsOrdinal = ({
  colorStops = [{
    stop: 0,
    color: _color_stops_utils.DEFAULT_CUSTOM_COLOR
  }],
  onChange,
  swatches
}) => {
  const getStopError = (stop, index) => {
    let error;
    if ((0, _color_stops_utils.isOrdinalStopInvalid)(stop)) {
      error = _i18n.i18n.translate('xpack.maps.styles.colorStops.ordinalStop.numberWarningLabel', {
        defaultMessage: 'Stop must be a number'
      });
    } else if (index !== 0 && colorStops[index - 1].stop >= stop) {
      error = _i18n.i18n.translate('xpack.maps.styles.colorStops.ordinalStop.numberOrderingWarningLabel', {
        defaultMessage: 'Stop must be greater than previous stop value'
      });
    }
    return error;
  };
  const renderStopInput = (stop, onStopChange, index) => {
    function handleOnChangeEvent(event) {
      const sanitizedValue = parseFloat(event.target.value);
      const newStopValue = isNaN(sanitizedValue) ? '' : sanitizedValue;
      onStopChange(newStopValue);
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      "aria-label": _i18n.i18n.translate('xpack.maps.styles.colorStops.ordinalStop.stopLabel', {
        defaultMessage: 'Stop'
      }),
      value: index === 0 ? '' : stop,
      onChange: handleOnChangeEvent,
      compressed: true,
      disabled: index === 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 7
      }
    });
  };
  return /*#__PURE__*/_react.default.createElement(_color_stops.ColorStops, {
    onChange: onChange,
    colorStops: colorStops,
    isStopsInvalid: _color_stops_utils.isOrdinalStopsInvalid,
    getStopError: getStopError,
    renderStopInput: renderStopInput,
    addNewRow: _color_stops_utils.addOrdinalRow,
    swatches: swatches,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  });
};
exports.ColorStopsOrdinal = ColorStopsOrdinal;
ColorStopsOrdinal.propTypes = {
  /**
   * Array of { stop, color }.
   * Stops are numbers in strictly ascending order.
   * The range is from the given stop number (inclusive) to the next stop number (exclusive).
   * Colors are color hex strings (3 or 6 character).
   */
  colorStops: _propTypes.default.arrayOf(_propTypes.default.shape({
    stopKey: _propTypes.default.number,
    color: _propTypes.default.string
  })),
  /**
   * Callback for when the color stops changes. Called with { colorStops, isInvalid }
   */
  onChange: _propTypes.default.func.isRequired
};