"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tmsLayerWizardConfig = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _xyz_tms_editor = require("./xyz_tms_editor");
var _xyz_tms_source = require("./xyz_tms_source");
var _raster_tile_layer = require("../../layers/raster_tile_layer/raster_tile_layer");
var _constants = require("../../../../common/constants");
var _world_map_layer_icon = require("../../layers/wizards/icons/world_map_layer_icon");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/sources/xyz_tms_source/layer_wizard.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const tmsLayerWizardConfig = exports.tmsLayerWizardConfig = {
  id: _constants.WIZARD_ID.TMS_LAYER,
  order: 10,
  categories: [_constants.LAYER_WIZARD_CATEGORY.REFERENCE],
  description: _i18n.i18n.translate('xpack.maps.source.ems_xyzDescription', {
    defaultMessage: 'Raster image tile map service using {z}/{x}/{y} url pattern.',
    values: {
      z: '{z}',
      x: '{x}',
      y: '{y}'
    }
  }),
  icon: _world_map_layer_icon.WorldMapLayerIcon,
  renderWizard: ({
    previewLayers
  }) => {
    const onSourceConfigChange = sourceConfig => {
      if (!sourceConfig) {
        previewLayers([]);
        return;
      }
      const layerDescriptor = _raster_tile_layer.RasterTileLayer.createDescriptor({
        sourceDescriptor: _xyz_tms_source.XYZTMSSource.createDescriptor(sourceConfig)
      });
      previewLayers([layerDescriptor]);
    };
    return /*#__PURE__*/_react.default.createElement(_xyz_tms_editor.XYZTMSEditor, {
      onSourceConfigChange: onSourceConfigChange,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 12
      }
    });
  },
  title: _xyz_tms_source.sourceTitle
};