"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TileServiceSelect = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _util = require("../../../util");
var _ems_unavailable_message = require("../../../components/ems_unavailable_message");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/sources/ems_tms_source/tile_service_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AUTO_SELECT = 'auto_select';
class TileServiceSelect extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      emsTmsOptions: [],
      hasLoaded: false
    });
    (0, _defineProperty2.default)(this, "_loadTmsOptions", async () => {
      try {
        const emsTMSServices = await (0, _util.getEmsTmsServices)();
        if (!this._isMounted) {
          return;
        }
        const emsTmsOptions = emsTMSServices.map(tmsService => {
          return {
            value: tmsService.getId(),
            text: tmsService.getDisplayName() ? tmsService.getDisplayName() : tmsService.getId()
          };
        });
        emsTmsOptions.unshift({
          value: AUTO_SELECT,
          text: _i18n.i18n.translate('xpack.maps.source.emsTile.autoLabel', {
            defaultMessage: 'Autoselect based on Kibana theme'
          })
        });
        this.setState({
          emsTmsOptions,
          hasLoaded: true
        });
      } catch (error) {
        if (this._isMounted) {
          this.setState({
            emsTmsOptions: [],
            hasLoaded: true
          });
        }
      }
    });
    (0, _defineProperty2.default)(this, "_onChange", e => {
      const value = e.target.value;
      const isAutoSelect = value === AUTO_SELECT;
      this.props.onTileSelect({
        id: isAutoSelect ? undefined : value,
        isAutoSelect
      });
    });
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  componentDidMount() {
    this._isMounted = true;
    this._loadTmsOptions();
  }
  render() {
    const helpText = this.state.emsTmsOptions.length === 0 ? (0, _ems_unavailable_message.getEmsUnavailableMessage)() : null;
    let selectedId;
    if (this.props.config) {
      selectedId = this.props.config.isAutoSelect ? AUTO_SELECT : this.props.config.id;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.source.emsTile.label', {
        defaultMessage: 'Tile service'
      }),
      helpText: helpText,
      display: "columnCompressed",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      hasNoInitialSelection: !selectedId,
      value: selectedId,
      options: this.state.emsTmsOptions,
      onChange: this._onChange,
      isLoading: !this.state.hasLoaded,
      disabled: this.state.hasLoaded && this.state.emsTmsOptions.length === 0,
      compressed: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 9
      }
    }));
  }
}
exports.TileServiceSelect = TileServiceSelect;