"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TitlePositionOptions = exports.DEFAULT_TITLE_POSITION = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/legacy_metric/metric_config_panel/title_position_option.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DEFAULT_TITLE_POSITION = exports.DEFAULT_TITLE_POSITION = 'top';
const titlePositions = [{
  id: 'top',
  label: _i18n.i18n.translate('xpack.lens.legacyMetric.titlePositions.top', {
    defaultMessage: 'Top'
  })
}, {
  id: 'bottom',
  label: _i18n.i18n.translate('xpack.lens.legacyMetric.titlePositions.bottom', {
    defaultMessage: 'Bottom'
  })
}];
const TitlePositionOptions = ({
  state,
  setState
}) => {
  var _state$titlePosition;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.lens.legacyMetric.titlePositionLabel', {
      defaultMessage: 'Title position'
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    "data-test-subj": "lnsMissingValuesSelect",
    legend: "This is a basic group",
    options: titlePositions,
    idSelected: (_state$titlePosition = state.titlePosition) !== null && _state$titlePosition !== void 0 ? _state$titlePosition : DEFAULT_TITLE_POSITION,
    onChange: value => {
      setState({
        ...state,
        titlePosition: value
      });
    },
    buttonSize: "compressed",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }));
};
exports.TitlePositionOptions = TitlePositionOptions;