"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.prepareInlineEditPanel = prepareInlineEditPanel;
var _public = require("@kbn/embeddable-plugin/public");
var _react = _interopRequireDefault(require("react"));
var _utils = require("../../utils");
var _helper = require("../helper");
var _state_management = require("./state_management");
var _chart_type_session_storage = require("../../chart_type_session_storage");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764738948373081548/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/react_embeddable/inline_editing/setup_inline_editing.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function prepareInlineEditPanel(initialState, getState, updateState, {
  dataLoading$,
  isNewlyCreated$
}, panelManagementApi, inspectorApi, {
  coreStart,
  visualizationMap,
  datasourceMap,
  ...startDependencies
}, navigateToLensEditor, uuid, parentApi) {
  return async function getConfigPanel({
    closeFlyout,
    onApply,
    onCancel,
    hideTimeFilterInfo,
    applyButtonLabel
  } = {}) {
    const currentState = getState();
    const isNewPanel = initialState.isNewPanel;
    const attributes = currentState.attributes;
    // Save the user's preferred chart type to session storage
    if (!isNewPanel && attributes) {
      (0, _chart_type_session_storage.saveUserChartTypeToSessionStorage)(attributes.visualizationType);
    }
    const activeDatasourceId = (0, _utils.getActiveDatasourceIdFromDoc)(attributes) || 'formBased';
    const {
      updatePanelState,
      updateSuggestion
    } = (0, _state_management.getStateManagementForInlineEditing)(activeDatasourceId, () => getState().attributes, (attrs, resetId = false) => {
      updateState({
        attributes: attrs,
        savedObjectId: resetId ? undefined : currentState.savedObjectId
      });
    }, visualizationMap, datasourceMap, startDependencies.data.query.filterManager.extract);
    const updateByRefInput = savedObjectId => {
      updateState({
        attributes,
        savedObjectId
      });
    };
    if ((attributes === null || attributes === void 0 ? void 0 : attributes.visualizationType) == null) {
      return null;
    }
    const {
      getEditLensConfiguration
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('../../async_services')));
    const Component = await getEditLensConfiguration(coreStart, startDependencies, visualizationMap, datasourceMap);
    const canNavigateToFullEditor = !(0, _helper.isTextBasedLanguage)(currentState) && panelManagementApi.isEditingEnabled() && navigateToLensEditor;
    return /*#__PURE__*/_react.default.createElement(Component, {
      closeFlyout: closeFlyout,
      attributes: attributes,
      updateByRefInput: updateByRefInput,
      updatePanelState: updatePanelState,
      updateSuggestion: updateSuggestion,
      datasourceId: activeDatasourceId,
      lensAdapters: inspectorApi.getInspectorAdapters(),
      dataLoading$: dataLoading$,
      panelId: uuid,
      savedObjectId: currentState.savedObjectId,
      navigateToLensEditor: canNavigateToFullEditor ? navigateToLensEditor(new _public.EmbeddableStateTransfer(coreStart.application.navigateToApp, coreStart.application.currentAppId$), true) : undefined,
      displayFlyoutHeader: true,
      canEditTextBasedQuery: (0, _helper.isTextBasedLanguage)(currentState),
      isNewPanel: panelManagementApi.isNewPanel(),
      onCancel: () => {
        panelManagementApi.onStopEditing(true,
        // DSL/form based charts are created via the full editor, so there's
        // an initial state to preserve. ES|QL charts are created inline, so it needs to pass an empty state
        // and the panelManagementApi will decide whether to remove the panel or not
        isNewlyCreated$.getValue() ? undefined : initialState);
        onCancel === null || onCancel === void 0 ? void 0 : onCancel();
      },
      onApply: newAttributes => {
        panelManagementApi.onStopEditing(false, {
          ...getState(),
          attributes: newAttributes
        });
        if (newAttributes.visualizationType != null) {
          onApply === null || onApply === void 0 ? void 0 : onApply(newAttributes);
        }
      },
      hideTimeFilterInfo: hideTimeFilterInfo,
      isReadOnly: panelManagementApi.canShowConfig() && !panelManagementApi.isEditingEnabled(),
      parentApi: parentApi,
      applyButtonLabel: applyButtonLabel,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 7
      }
    });
  };
}